/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.gf3;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.security.SecuritySniffer;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.DomainXml;
import com.sun.enterprise.v3.server.DomainXmlPersistence;
import com.sun.enterprise.v3.services.impl.LogManagerService;
import com.sun.enterprise.web.WebDeployer;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.resource.ResourceException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.deployment.autodeploy.AutoDeployService;
import org.glassfish.embed.AppServer;
import org.glassfish.embed.impl.EmbeddedAPIClassLoaderServiceImpl;
import org.glassfish.embed.impl.EmbeddedDomainXml;
import org.glassfish.embed.impl.EmbeddedServerEnvironment;
import org.glassfish.embed.impl.EmbeddedWebDeployer;
import org.glassfish.embed.impl.EntityResolverImpl;
import org.glassfish.embed.impl.ScatteredWarHandler;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.web.WebEntityResolver;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;
import org.nuxeo.common.Environment;

public class GlassFishServer
extends AppServer {
    public GlassFishServer(URL domainXmlUrl) {
        super(domainXmlUrl);
    }

    public GlassFishServer(int port) {
        super(port);
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public void loadInhabitant(Object instance) {
        this.habitat.add(Inhabitants.create((Object)instance));
    }

    public ActionReport execute(String command, Properties args) {
        PlainTextActionReporter reporter = new PlainTextActionReporter();
        CommandRunner commandRunner = (CommandRunner)this.habitat.getComponent(CommandRunner.class);
        commandRunner.doCommand(command, args, (ActionReport)reporter);
        return reporter;
    }

    public String getVersion() {
        ActionReport report = this.execute("version", new Properties());
        return report.getMessage();
    }

    public ActionReport createJdbcResource(Properties args) {
        return this.execute("create-jdbc-resource", args);
    }

    public ActionReport deleteJdbcResource(Properties args) {
        return this.execute("delete-jdbc-resource", args);
    }

    public ActionReport listJdbcResources(Properties args) {
        return this.execute("list-jdbc-resources", args);
    }

    public ActionReport createJdbcConnectionPool(Properties args) {
        return this.execute("create-jdbc-connection-pool", args);
    }

    public ActionReport deleteJdbcConnectionPool(Properties args) {
        return this.execute("delete-jdbc-connection-pool", args);
    }

    public String[] listJdbcConnectionPools() {
        ActionReport ar = this.execute("list-jdbc-connection-pools", new Properties());
        if (ar.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ActionReport.MessagePart parts : ar.getTopMessagePart().getChildren()) {
            result.add(parts.getMessage());
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean pingJdbcConnectionPool(String poolName) throws ResourceException {
        ConnectorRuntime connRuntime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class);
        return connRuntime.pingConnectionPool(poolName);
    }

    protected InhabitantsParser decorateInhabitantsParser(InhabitantsParser parser) {
        parser.habitat.add((Inhabitant)new ExistingSingletonInhabitant(AppServer.class, (Object)this));
        Inhabitant swh = Inhabitants.create((Object)new ScatteredWarHandler());
        parser.habitat.add(swh);
        parser.habitat.addIndex(swh, ArchiveHandler.class.getName(), null);
        parser.drop(LogManagerService.class);
        parser.drop(AdminConsoleAdapter.class);
        try {
            Class.forName("org.glassfish.deployment.autodeploy.AutoDeployService");
            parser.drop(AutoDeployService.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        parser.replace(APIClassLoaderServiceImpl.class, EmbeddedAPIClassLoaderServiceImpl.class);
        parser.replace(DomainXml.class, EmbeddedDomainXml.class);
        parser.replace(DomainXmlPersistence.class, EmbeddedDomainXml.class);
        parser.replace(ServerEnvironmentImpl.class, EmbeddedServerEnvironment.class);
        try {
            parser.drop(SecuritySniffer.class);
            parser.drop(RealmAdapter.class);
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        parser.replace(WebDeployer.class, EmbeddedWebDeployer.class);
        parser.replace(WebEntityResolver.class, EntityResolverImpl.class);
        return parser;
    }

    protected File createTempDir() throws IOException {
        return new File(Environment.getDefault().getHome().getAbsolutePath() + "/glassfish/bin");
    }
}

