/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.gf3;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import java.io.File;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.embed.ScatteredWar;
import org.nuxeo.common.Environment;
import org.nuxeo.common.server.WebApplication;
import org.nuxeo.runtime.gf3.GlassFishServer;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class GF3Component
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(GF3Component.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.server");
    public static final String XP_WEB_APP = "webapp";
    public static final String XP_DATA_SOURCE = "datasource";
    protected GlassFishServer server;

    public GlassFishServer getServer() {
        return this.server;
    }

    public void activate(ComponentContext context) throws Exception {
        Environment env = Environment.getDefault();
        File file = new File(env.getConfig(), "domain.xml");
        if (file.exists()) {
            log.info((Object)("Starting GF3 server:" + file.toURI().toURL()));
            this.server = new GlassFishServer(file.toURI().toURL());
        } else {
            log.info((Object)"activate : Starting GF3 server with no domain.xml");
            this.server = new GlassFishServer(8080);
        }
        file = new File(env.getConfig(), "default-web.xml");
        if (file.exists()) {
            log.info((Object)("activate : GF3 server using default-web.xml:" + file.toURI().toURL()));
            this.server.setDefaultWebXml(file.toURI().toURL());
        }
        log.info((Object)"Async. Deploying RARs");
        Thread deployerThread = new Thread((Runnable)new RarDeployer(), "Deployer");
        deployerThread.setPriority(10);
        deployerThread.start();
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.warn((Object)"deactivate : Stopping glassfish server");
        this.server.stop();
        this.server = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_WEB_APP.equals(extensionPoint)) {
            WebApplication app = (WebApplication)contribution;
            log.info((Object)("Async. Deploying WAR:  " + app.getName() + "; context path:  " + app.getContextPath() + " webRoot: " + app.getWebRoot()));
            Thread deployerThread = new Thread((Runnable)new WarDeployer(app), "Deployer");
            deployerThread.setPriority(10);
            deployerThread.start();
        } else if (XP_DATA_SOURCE.equals(extensionPoint)) {
            log.debug((Object)"GF3 ignoring extension point datasource");
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_WEB_APP.equals(extensionPoint) || XP_DATA_SOURCE.equals(extensionPoint)) {
            // empty if block
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == GlassFishServer.class) {
            return adapter.cast((Object)this.server);
        }
        return null;
    }

    class RarDeployer
    implements Runnable {
        RarDeployer() {
        }

        @Override
        public void run() {
            ConnectorsClassLoaderUtil ccu = (ConnectorsClassLoaderUtil)GF3Component.this.server.getHabitat().getByType(ConnectorsClassLoaderUtil.class);
            ConnectorRuntime connSvc = (ConnectorRuntime)GF3Component.this.server.getHabitat().getByContract(ConnectorRuntime.class);
            Applications apps = (Applications)GF3Component.this.server.getHabitat().getComponent(Applications.class);
            for (ConnectorModule cm : apps.getModules(ConnectorModule.class)) {
                log.info((Object)("Loading RA " + cm.getName()));
                try {
                    connSvc.createActiveResourceAdapter(cm.getLocation(), cm.getName(), (ClassLoader)ccu.createRARClassLoader(cm.getLocation()));
                    log.info((Object)("RA started: " + cm.getName()));
                }
                catch (Exception e) {
                    log.error((Object)("Failed to deploy RAR: " + cm.getName()), (Throwable)e);
                }
            }
        }
    }

    class WarDeployer
    implements Runnable {
        final WebApplication app;

        WarDeployer(WebApplication app) {
            this.app = app;
        }

        @Override
        public void run() {
            File webXmlFile;
            File home = Environment.getDefault().getHome();
            File webRoot = new File(home, this.app.getWebRoot());
            String webXml = this.app.getConfigurationFile();
            if (webXml == null) {
                webXmlFile = new File(webRoot, "WEB-INF/web.xml");
                log.debug((Object)("GF3 trying to use web.xml: " + webXmlFile));
            } else {
                webXmlFile = new File(home, webXml);
                log.debug((Object)("GF3 trying using web.xml: " + webXmlFile));
            }
            File webClasses = new File(webRoot, "WEB-INF/classes");
            log.debug((Object)("GF3 trying using web classes from: " + webClasses));
            try {
                ScatteredWar war = new ScatteredWar(this.app.getName(), webRoot, webXmlFile, Collections.singleton(webClasses.toURI().toURL()));
                log.debug((Object)("GF3 deploying scattered war : " + this.app.getName() + " with context path : " + this.app.getContextPath()));
                GF3Component.this.server.deployWar(war, this.app.getContextPath());
                log.info((Object)("WAR started: " + this.app.getName()));
            }
            catch (Exception e) {
                log.error((Object)("Failed to deploy WAR: " + this.app.getName()), (Throwable)e);
            }
        }
    }
}

