/*
 * (C) Copyright 2006-2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.jboss.deployment.preprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.jboss.deployment.preprocessor.install.CommandProcessor;
import org.nuxeo.runtime.jboss.deployment.preprocessor.install.DOMCommandsParser;
import org.nuxeo.runtime.jboss.deployment.preprocessor.template.TemplateContribution;
import org.w3c.dom.DocumentFragment;

/**
 * @author  <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
@XObject("fragment")
public class FragmentDescriptor {

    private static final Log log = LogFactory.getLog(FragmentDescriptor.class);

    // the name is the name of the XML fragment file for XML fragments
    // or the name of the JAR container for archive or directory fragments
    @XNode("@name")
    public String name;

    public String fileName;
    public String filePath;

    @XNodeList(value = "extension", type = TemplateContribution[].class, componentType = TemplateContribution.class)
    public TemplateContribution[] contributions;

    @XNodeList(value = "require", type = ArrayList.class, componentType = String.class)
    public List<String> requires;

    @XNodeList(value = "requiredBy", type = String[].class, componentType = String.class)
    public String[] requiredBy;

    @XNodeMap(value = "template", key = "@name", type = HashMap.class, componentType = TemplateDescriptor.class)
    public Map<String, TemplateDescriptor> templates;

    public CommandProcessor install;

    public CommandProcessor uninstall;

    @XContent("install")
    public void setInstallCommands(DocumentFragment df) {
        try {
            install = DOMCommandsParser.parse(df);
        } catch (Exception e) {
            log.error("Failed to set install commands");
        }
    }

    @XContent("uninstall")
    public void setUninstallCommands(DocumentFragment df) {
        try {
            uninstall = DOMCommandsParser.parse(df);
        } catch (Exception e) {
            log.error("Failed to set uninstall commands");
        }
    }

    @Override
    public String toString() {
        return name + " [" + fileName + "]";
    }
}
