/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.ZipUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamHotReloadPreprocessor {
    public static final String SEAM_HOT_RELOAD_DIR = "nuxeo.war/WEB-INF/dev";
    public static final String SEAM_PATCHED_JARS_DIRECTORY = "seamHotReloadableJars";
    public static final String SEAMJAR_MARKER = "seam.properties";
    public static final String SEAM_HOT_RELOAD_GLOBAL_CONFIG = "config/seam-debug.properties";
    public static final String SEAM_HOT_RELOAD_SYSTEM_PROP = "org.nuxeo.seam.debug";
    protected final Logger log;
    protected final File earDirectory;
    protected final List<String> globalyDefinedReloadableClasses = new ArrayList<String>();
    protected boolean enabled = false;

    public SeamHotReloadPreprocessor(File earDirectory, Logger log) {
        this.log = log;
        this.earDirectory = earDirectory;
        File seamDebugFile = new File(earDirectory, SEAM_HOT_RELOAD_GLOBAL_CONFIG);
        if (seamDebugFile.exists()) {
            this.enabled = true;
            try {
                FileInputStream seamDebugPropertyStream = new FileInputStream(seamDebugFile);
                Properties props = new Properties();
                props.load(seamDebugPropertyStream);
                ((InputStream)seamDebugPropertyStream).close();
                Enumeration<?> keys = props.propertyNames();
                while (keys.hasMoreElements()) {
                    String fcn = (String)keys.nextElement();
                    this.globalyDefinedReloadableClasses.add(fcn);
                }
                log.info((Object)"Nuxeo's Seam HotReload Preprocessor is enabled");
                System.setProperty(SEAM_HOT_RELOAD_SYSTEM_PROP, "true");
            }
            catch (Exception e) {
                log.error((Object)"Error duing parsing of config/seam-debug.properties", (Throwable)e);
            }
        } else {
            log.info((Object)"Nuxeo's Seam HotReload Preprocessus is not enabled");
            this.enabled = false;
        }
    }

    protected File getJar(DeploymentInfo di) throws DeploymentException {
        try {
            String url = di.url.toString();
            url = url.replace(" ", "%20");
            return new File(new URI(url));
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot get jar: " + di.shortName, (Throwable)e);
        }
    }

    protected List<String> getHotReloadableSeamClasses(File jar) {
        ArrayList<String> fullClassNames;
        block4: {
            fullClassNames = null;
            try {
                InputStream seamProperties = ZipUtils.getEntryContentAsStream((File)jar, (String)SEAMJAR_MARKER);
                if (seamProperties != null) {
                    Properties props = new Properties();
                    props.load(seamProperties);
                    seamProperties.close();
                    fullClassNames = new ArrayList<String>();
                    Enumeration<?> keys = props.propertyNames();
                    while (keys.hasMoreElements()) {
                        String fcn = (String)keys.nextElement();
                        fullClassNames.add(fcn);
                    }
                    fullClassNames.addAll(this.globalyDefinedReloadableClasses);
                }
            }
            catch (Exception e) {
                if (!jar.getName().endsWith("jar")) break block4;
                this.log.warn((Object)("Seam dePloyer can not scan archive " + jar.getAbsolutePath()));
            }
        }
        return fullClassNames;
    }

    public void doProcess(List<DeploymentInfo> subDeployments) throws Exception {
        for (DeploymentInfo di : subDeployments) {
            File jar = this.getJar(di);
            List<String> classNames = this.getHotReloadableSeamClasses(jar);
            if (classNames == null || classNames.size() <= 0) continue;
            this.log.info((Object)("SeamHotReloadPreprocess found Seam archive in " + jar.getAbsolutePath()));
            this.splitSeamJar(di, jar, classNames);
        }
    }

    protected String getSeamHotReloadDir() {
        Path path = new Path(this.earDirectory.getAbsolutePath());
        File seamHRD = new File((path = path.append(SEAM_HOT_RELOAD_DIR)).toString());
        if (!seamHRD.exists()) {
            seamHRD.mkdirs();
        }
        return seamHRD.getAbsolutePath();
    }

    public void initSpecialDirectory() {
        String dirPath = this.getDirForPatchedSeamJars();
        File dir = new File(dirPath);
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                file.delete();
            }
        }
    }

    public boolean isSeamHotReloadEnabled() {
        return this.enabled;
    }

    protected String getDirForPatchedSeamJars() {
        Path path = new Path(this.earDirectory.getAbsolutePath());
        File seamPJD = new File((path = path.append(SEAM_PATCHED_JARS_DIRECTORY)).toString());
        if (!seamPJD.exists() && this.isSeamHotReloadEnabled()) {
            seamPJD.mkdirs();
        }
        return seamPJD.getAbsolutePath();
    }

    protected void splitSeamJar(DeploymentInfo di, File originalJar, List<String> classNames) throws Exception {
        String patchedJarPath = new Path(this.getDirForPatchedSeamJars()).append(originalJar.getName()).toString();
        File patchedJar = new File(patchedJarPath);
        ArrayList<String> jarEntriesToExtract = new ArrayList<String>();
        for (String cn : classNames) {
            String path = cn.replaceAll("\\.", "/") + ".class";
            jarEntriesToExtract.add(path);
        }
        ZipFile inputZip = new ZipFile(originalJar);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(patchedJar));
        Enumeration<? extends ZipEntry> inputZipEntries = inputZip.entries();
        while (inputZipEntries.hasMoreElements()) {
            int len;
            ZipEntry ze = inputZipEntries.nextElement();
            if (jarEntriesToExtract.contains(ze.getName())) {
                String path = ze.getName();
                String dstPath = new Path(this.getSeamHotReloadDir()).append(path).toString();
                String dstFolderPath = new Path(dstPath).removeLastSegments(1).toString();
                File dstFolder = new File(dstFolderPath);
                if (!dstFolder.exists()) {
                    dstFolder.mkdirs();
                }
                File dst = new File(dstPath);
                FileUtils.copyToFile((InputStream)inputZip.getInputStream(ze), (File)dst);
                continue;
            }
            out.putNextEntry(ze);
            InputStream srcEntry = inputZip.getInputStream(ze);
            byte[] buf = new byte[1024];
            while ((len = srcEntry.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            srcEntry.close();
        }
        out.close();
        this.updateDeploymentInfo(di, patchedJar);
    }

    protected void updateDeploymentInfo(DeploymentInfo di, File newJar) throws MalformedURLException {
        di.url = newJar.toURL();
        di.watch = newJar.toURL();
    }
}

