/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.IOException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.runtime.jboss.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.jboss.deployment.preprocessor.install.CommandContext;

public class DeleteCommand
implements Command {
    protected final Path path;

    public DeleteCommand(Path path) {
        this.path = path;
    }

    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File file = new File(baseDir, ctx.expandVars(this.path.toString()));
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            FileUtils.deleteTree((File)file);
        }
    }

    public String toString() {
        return "delete " + this.path.toString();
    }

    public String toString(CommandContext ctx) {
        return "delete " + ctx.expandVars(this.path.toString());
    }
}

