/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment.preprocessor.install.filters;

import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;

public abstract class AbstractFilter
implements PathFilter {
    protected Path pattern;

    protected AbstractFilter(Path pattern) {
        this.pattern = pattern;
    }

    public void setPattern(Path pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = new Path(pattern);
    }

    public Path getPattern() {
        return this.pattern;
    }

    public boolean accept(Path path, boolean defaultPolicy) {
        boolean match = AbstractFilter.segmentsMatch(this.pattern, path);
        return match ? !defaultPolicy : defaultPolicy;
    }

    protected static boolean segmentsMatch(Path pattern, Path path) {
        int patternLen = pattern.segmentCount();
        int k = 0;
        int len = path.segmentCount();
        block0: for (int i = 0; i < len; ++i) {
            if (k >= patternLen) {
                return false;
            }
            String segPattern = pattern.segment(k);
            String segment = path.segment(i);
            if (segPattern.equals("**")) {
                if (++k == patternLen) {
                    return true;
                }
                String match = pattern.segment(k);
                while (i < len) {
                    if (AbstractFilter.segmentMatch(match, path.segment(i))) {
                        ++k;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (AbstractFilter.segmentMatch(segPattern, segment)) {
                ++k;
                continue;
            }
            return false;
        }
        return k >= patternLen;
    }

    public static boolean segmentMatch(String pattern, String segment) {
        if (pattern.equals("*")) {
            return true;
        }
        int p = pattern.indexOf(42);
        if (p == -1) {
            return pattern.equals(segment);
        }
        if (p == 0) {
            if (!segment.endsWith(pattern.substring(1))) {
                return false;
            }
        } else if (p == pattern.length() - 1) {
            if (!segment.startsWith(pattern.substring(0, p))) {
                return false;
            }
        } else {
            String prefix = pattern.substring(0, p);
            String suffix = pattern.substring(p + 1);
            if (!segment.startsWith(prefix) || !segment.endsWith(suffix)) {
                return false;
            }
        }
        return true;
    }
}

