/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.interceptors;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class TraceInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1839232187157414668L;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof MethodInvocation) {
            Date date = new Date();
            String d = sdf.format(date);
            MethodInvocation mi = (MethodInvocation)invocation;
            StackTraceElement[] st = new Exception().getStackTrace();
            Object[] ar = mi.getArguments();
            List<Object> args = ar == null ? new ArrayList() : Arrays.asList(ar);
            System.out.println("---------------------------------------------");
            System.out.println("# " + d + " : Invoking : " + mi.getActualMethod());
            System.out.println("---------------------------------------------");
            System.out.println("#Args: " + args);
            System.out.println("---------------------------------------------");
            double s = System.currentTimeMillis();
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                System.out.println(" [" + ((double)System.currentTimeMillis() - s) / 1000.0 + " sec.]");
                System.out.println("---------------------------------------------");
                for (int i = 0; i < Math.min(st.length, 15); ++i) {
                    System.out.println(">> " + st[i]);
                }
            }
        }
        return invocation.invokeNext();
    }

    public String getName() {
        return this.getClass().getName();
    }
}

