/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jetty;

import java.io.File;
import java.net.URL;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.nuxeo.common.Environment;
import org.nuxeo.common.server.WebApplication;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.server");
    public static final String XP_WEB_APP = "webapp";
    public static final String XP_DATA_SOURCE = "datasource";
    protected Server server;
    protected ContextHandlerCollection contexts = new ContextHandlerCollection();
    protected File config;
    protected File log;

    public Server getServer() {
        return this.server;
    }

    public void activate(ComponentContext context) throws Exception {
        File file;
        URL cfg = null;
        String cfgName = Framework.getProperty((String)"org.nuxeo.jetty.config");
        if (cfgName != null) {
            if (cfgName.contains(":/")) {
                cfg = new URL(cfgName);
            } else {
                file = new File(cfgName);
                if (file.isFile()) {
                    cfg = file.toURI().toURL();
                }
            }
        } else {
            file = new File(Environment.getDefault().getConfig(), "jetty.xml");
            if (file.isFile()) {
                cfg = file.toURI().toURL();
            }
        }
        if (cfg != null) {
            XmlConfiguration configuration = new XmlConfiguration(cfg);
            this.server = (Server)configuration.configure();
        } else {
            int p = 8080;
            String port = Environment.getDefault().getProperty("http_port");
            if (port != null) {
                try {
                    p = Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.server = new Server(p);
        }
        Handler[] handlers = this.server.getHandlers();
        if (handlers != null && handlers.length > 0 && handlers[0] instanceof ContextHandlerCollection) {
            this.contexts = (ContextHandlerCollection)handlers[0];
        } else if (handlers == null || handlers.length == 0) {
            this.contexts = new ContextHandlerCollection();
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            File logDir = Environment.getDefault().getLog();
            logDir.mkdirs();
            File logFile = new File(logDir, "jetty.log");
            NCSARequestLog requestLog = new NCSARequestLog(logFile.getAbsolutePath());
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            handlers = new Handler[]{this.contexts, requestLogHandler};
            this.server.setHandlers(handlers);
            this.server.setSendServerVersion(true);
            this.server.setStopAtShutdown(true);
        } else {
            this.contexts = new ContextHandlerCollection();
            Handler[] newHandlers = new Handler[handlers.length + 1];
            newHandlers[0] = this.contexts;
            System.arraycopy(handlers, 0, newHandlers, 0, handlers.length);
            this.server.setHandlers(newHandlers);
        }
        this.server.start();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.server.stop();
        this.server = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_WEB_APP.equals(extensionPoint)) {
            File defWebXml;
            String webXml;
            File home = Environment.getDefault().getHome();
            WebApplication app = (WebApplication)contribution;
            WebAppContext ctx = new WebAppContext();
            ctx.setContextPath(app.getContextPath());
            String root = app.getWebRoot();
            if (root != null) {
                File file = new File(home, root);
                ctx.setWar(file.getAbsolutePath());
            }
            if ((webXml = app.getConfigurationFile()) != null) {
                File file = new File(home, root);
                ctx.setDescriptor(file.getAbsolutePath());
            }
            if ((defWebXml = new File(Environment.getDefault().getConfig(), "default-web.xml")).isFile()) {
                ctx.setDefaultsDescriptor(defWebXml.getAbsolutePath());
            }
            this.contexts.addHandler((Handler)ctx);
            ctx.start();
        } else if (XP_DATA_SOURCE.equals(extensionPoint)) {
            // empty if block
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_WEB_APP.equals(extensionPoint) || XP_DATA_SOURCE.equals(extensionPoint)) {
            // empty if block
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Server.class) {
            return adapter.cast(this.server);
        }
        return null;
    }
}

