/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jetty;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebInfConfiguration;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.xml.XmlConfiguration;
import org.nuxeo.common.Environment;
import org.nuxeo.common.server.WebApplication;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jetty.ContextManager;
import org.nuxeo.runtime.jetty.FilterDescriptor;
import org.nuxeo.runtime.jetty.Log4JLogger;
import org.nuxeo.runtime.jetty.ServletContextListenerDescriptor;
import org.nuxeo.runtime.jetty.ServletDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class JettyComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.server");
    public static final String XP_WEB_APP = "webapp";
    public static final String XP_SERVLET = "servlet";
    public static final String XP_FILTER = "filter";
    public static final String XP_LISTENERS = "listeners";
    public static final String P_SCAN_WEBDIR = "org.nuxeo.runtime.jetty.scanWebDir";
    protected Server server;
    protected ContextManager ctxMgr;
    protected ContextHandlerCollection warContexts;
    protected File config;
    protected File log;
    private static final org.apache.commons.logging.Log logger = LogFactory.getLog(JettyComponent.class);

    public Server getServer() {
        return this.server;
    }

    public void activate(ComponentContext context) throws Exception {
        String scanWebDir;
        File file;
        URL cfg = null;
        String cfgName = Framework.getProperty((String)"org.nuxeo.jetty.config");
        if (cfgName != null) {
            if (cfgName.contains(":/")) {
                cfg = new URL(cfgName);
            } else {
                file = new File(cfgName);
                if (file.isFile()) {
                    cfg = file.toURI().toURL();
                }
            }
        } else {
            file = new File(Environment.getDefault().getConfig(), "jetty.xml");
            if (file.isFile()) {
                cfg = file.toURI().toURL();
            }
        }
        boolean hasConfigFile = false;
        if (cfg != null) {
            hasConfigFile = true;
            XmlConfiguration configuration = new XmlConfiguration(cfg);
            this.server = (Server)configuration.configure();
        } else {
            int p = 8080;
            String port = Environment.getDefault().getProperty("http_port");
            if (port != null) {
                try {
                    p = Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.server = new Server(p);
        }
        if (!hasConfigFile) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            File logDir = Environment.getDefault().getLog();
            logDir.mkdirs();
            File logFile = new File(logDir, "jetty.log");
            NCSARequestLog requestLog = new NCSARequestLog(logFile.getAbsolutePath());
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            this.server.addHandler((Handler)requestLogHandler);
            this.server.setSendServerVersion(true);
            this.server.setStopAtShutdown(true);
        }
        HandlerCollection hc = (HandlerCollection)this.server.getHandler();
        this.warContexts = (ContextHandlerCollection)hc.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.warContexts == null) {
            this.warContexts = new ContextHandlerCollection();
            this.server.addHandler((Handler)this.warContexts);
        }
        if ((scanWebDir = Framework.getProperty((String)P_SCAN_WEBDIR)) != null && scanWebDir.equals("true")) {
            logger.info((Object)"Scanning for WARs in web directory");
            File web = Environment.getDefault().getWeb();
            this.scanForWars(web);
        }
        this.ctxMgr = new ContextManager(this.server);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.ctxMgr = null;
        this.server.stop();
        this.server = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_WEB_APP.equals(extensionPoint)) {
            File defWebXml;
            String webXml;
            File home = Environment.getDefault().getHome();
            WebApplication app = (WebApplication)contribution;
            WebAppContext ctx = new WebAppContext();
            ctx.setContextPath(app.getContextPath());
            String root = app.getWebRoot();
            if (root != null) {
                File file = new File(home, root);
                ctx.setWar(file.getAbsolutePath());
            }
            if ((webXml = app.getConfigurationFile()) != null) {
                File file = new File(home, root);
                ctx.setDescriptor(file.getAbsolutePath());
            }
            if ((defWebXml = new File(Environment.getDefault().getConfig(), "default-web.xml")).isFile()) {
                ctx.setDefaultsDescriptor(defWebXml.getAbsolutePath());
            }
            if ("/".equals(app.getContextPath())) {
                this.server.addHandler((Handler)ctx);
            } else {
                this.warContexts.addHandler((Handler)ctx);
            }
            Log.setLog((Logger)new Log4JLogger(logger));
            if (ctx.isFailed()) {
                logger.error((Object)"Error in war deployment");
            }
        } else if (XP_FILTER.equals(extensionPoint)) {
            this.ctxMgr.addFilter((FilterDescriptor)contribution);
        } else if (XP_SERVLET.equals(extensionPoint)) {
            this.ctxMgr.addServlet((ServletDescriptor)contribution);
        } else if (XP_LISTENERS.equals(extensionPoint)) {
            this.ctxMgr.addLifecycleListener((ServletContextListenerDescriptor)contribution);
        }
    }

    public ContextManager getContextManager() {
        return this.ctxMgr;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (!XP_WEB_APP.equals(extensionPoint)) {
            if (XP_FILTER.equals(extensionPoint)) {
                this.ctxMgr.removeFilter((FilterDescriptor)contribution);
            } else if (XP_SERVLET.equals(extensionPoint)) {
                this.ctxMgr.removeServlet((ServletDescriptor)contribution);
            } else if (XP_LISTENERS.equals(extensionPoint)) {
                this.ctxMgr.removeLifecycleListener((ServletContextListenerDescriptor)contribution);
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Server.class) {
            return adapter.cast(this.server);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) throws Exception {
        if (this.server == null) {
            return;
        }
        this.ctxMgr.applyLifecycleListeners();
        try {
            Thread t = Thread.currentThread();
            ClassLoader oldcl = t.getContextClassLoader();
            t.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                this.server.start();
            }
            finally {
                t.setContextClassLoader(oldcl);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start Jetty server", (Throwable)e);
        }
    }

    private void scanForWars(File dir) {
        this.scanForWars(dir, "");
    }

    private void scanForWars(File dir, String basePath) {
        File[] roots = dir.listFiles();
        if (roots != null) {
            for (File root : roots) {
                String name = root.getName();
                if (name.endsWith(".war")) {
                    logger.info((Object)("Found war: " + name));
                    name = name.substring(0, name.length() - 4);
                    boolean isRoot = "root".equals(name);
                    String ctxPath = isRoot ? "/" : basePath + "/" + name;
                    WebAppContext ctx = new WebAppContext(root.getAbsolutePath(), ctxPath);
                    ctx.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration()});
                    if (isRoot) {
                        this.server.addHandler((Handler)ctx);
                        continue;
                    }
                    this.warContexts.addHandler((Handler)ctx);
                    continue;
                }
                if (!root.isDirectory()) continue;
                this.scanForWars(root, basePath + "/" + name);
            }
        }
    }
}

