/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.resource.ResourceException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.ConnectionHandleInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.MCFConnectionInterceptor;
import org.apache.geronimo.connector.outbound.PoolIdleReleaserTimer;
import org.apache.geronimo.connector.outbound.SubjectInterceptor;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.TCCLInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.nuxeo.runtime.jtajca.NuxeoConnectionTrackingCoordinator;
import org.nuxeo.runtime.jtajca.NuxeoValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoConnectionManager
extends AbstractConnectionManager {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(NuxeoConnectionManager.class);
    protected final NuxeoConnectionTrackingCoordinator coordinator;
    final ActiveMonitor activemonitor;
    final Nosharing nosharing;

    public NuxeoConnectionManager(int activettl, NuxeoValidationSupport validationSupport, TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, NuxeoConnectionTrackingCoordinator connectionTracker, RecoverableTransactionManager transactionManager, String name, ClassLoader classLoader) {
        super((AbstractConnectionManager.Interceptors)new InterceptorsImpl(validationSupport, transactionSupport, pooling, subjectSource, name, connectionTracker, (TransactionManager)transactionManager, classLoader), transactionManager, name);
        this.coordinator = connectionTracker;
        this.activemonitor = new ActiveMonitor(activettl);
        this.nosharing = new Nosharing();
    }

    public void doStop() throws Exception {
        if (this.getConnectionCount() < this.getPartitionMinSize()) {
            Thread.sleep(10L);
        }
        super.doStop();
    }

    public List<ActiveMonitor.TimeToLive> killActiveTimedoutConnections(long clock) {
        return this.activemonitor.killTimedoutConnections(clock);
    }

    public long getKilledConnectionCount() {
        return this.activemonitor.killedCount;
    }

    public int getActiveTimeoutMinutes() {
        return this.activemonitor.ttl / 60000;
    }

    public Set<ConnectionInfo> listActive() {
        return this.activemonitor.ttls.values().stream().map(ttl -> ttl.info).collect(Collectors.toSet());
    }

    public void enterActiveMonitor(int delay) {
        this.activemonitor.enter(delay);
    }

    public void exitActiveTimedout() {
        this.activemonitor.exit();
    }

    public void enterNoSharing() {
        this.nosharing.enter();
    }

    public void exitNoSharing() {
        this.nosharing.exit();
    }

    class Nosharing
    implements ConnectionTracker {
        final ThreadLocal<Boolean> noSharingHolder = new ThreadLocal();

        Nosharing() {
            NuxeoConnectionManager.this.coordinator.addTracker(this);
        }

        public void handleObtained(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, boolean reassociate) throws ResourceException {
        }

        public void handleReleased(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        }

        public void setEnvironment(ConnectionInfo connectionInfo, String key) {
            connectionInfo.setUnshareable(this.noSharingHolder.get() != null);
        }

        void enter() {
            this.noSharingHolder.set(Boolean.TRUE);
        }

        void exit() {
            this.noSharingHolder.remove();
        }
    }

    class ActiveMonitor
    implements ConnectionTracker {
        final int ttl;
        final Map<ConnectionInfo, TimeToLive> ttls = new ConcurrentHashMap<ConnectionInfo, TimeToLive>();
        long killedCount = 0L;
        CleanupTask cleanup = new CleanupTask();
        final ThreadLocal<Integer> context = new ThreadLocal();

        ActiveMonitor(int delay) {
            this.ttl = delay;
            if (this.ttl > 0) {
                this.scheduleCleanups();
            }
            NuxeoConnectionManager.this.coordinator.addTracker(this);
        }

        void cancelCleanups() {
            this.cleanup.cancel();
        }

        void scheduleCleanups() {
            PoolIdleReleaserTimer.getTimer().scheduleAtFixedRate((TimerTask)this.cleanup, 60000L, 60000L);
        }

        public void handleObtained(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, boolean reassociate) throws ResourceException {
            int delay = this.ttl();
            if (delay > 0) {
                this.ttls.put(connectionInfo, new TimeToLive(connectionInfo, Thread.currentThread().getName(), System.currentTimeMillis(), delay));
            }
        }

        public void handleReleased(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
            this.ttls.remove(connectionInfo);
        }

        public void setEnvironment(ConnectionInfo connectionInfo, String key) {
        }

        public List<TimeToLive> killTimedoutConnections(long clock) {
            LinkedList<TimeToLive> killed = new LinkedList<TimeToLive>();
            Iterator<TimeToLive> it = this.ttls.values().iterator();
            while (it.hasNext()) {
                TimeToLive ttl = it.next();
                if (ttl.deadline > clock) continue;
                ttl.killAndLog();
                killed.add(ttl);
                it.remove();
            }
            return killed;
        }

        public void log() {
            for (TimeToLive ttl : this.ttls.values()) {
                LogFactory.getLog(TimeToLive.class).warn((Object)ttl, (Throwable)ttl.info.getTrace());
            }
        }

        public Set<TimeToLive> list() {
            return new HashSet<TimeToLive>(this.ttls.values());
        }

        public void enter(int delay) {
            this.context.set(delay);
        }

        public void exit() {
            this.context.remove();
        }

        int ttl() {
            Integer value = this.context.get();
            if (value != null) {
                return value;
            }
            return this.ttl;
        }

        public class TimeToLive {
            public final ConnectionInfo info;
            public final String threadName;
            public final long obtained;
            public final long deadline;

            TimeToLive(ConnectionInfo info, String threadName, long obtained, int delay) {
                this.info = info;
                this.threadName = threadName;
                this.obtained = System.currentTimeMillis();
                this.deadline = obtained + (long)delay;
            }

            void killAndLog() {
                try {
                    this.info.getManagedConnectionInfo().getPoolInterceptor().returnConnection(this.info, ConnectionReturnAction.DESTROY);
                }
                catch (Throwable error) {
                    if (error instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        throw error;
                    }
                    LogFactory.getLog(NuxeoConnectionTrackingCoordinator.class).error((Object)("Caught error while killing " + this.info), error);
                }
                finally {
                    ++ActiveMonitor.this.killedCount;
                    LogFactory.getLog(NuxeoConnectionTrackingCoordinator.class).error((Object)("Killed " + this.message(new StringBuilder())), (Throwable)this.info.getTrace());
                }
            }

            void log(long clock) {
                if (this.deadline < clock) {
                    LogFactory.getLog(NuxeoConnectionTrackingCoordinator.class).info((Object)this.message(new StringBuilder()), (Throwable)this.info.getTrace());
                } else {
                    LogFactory.getLog(NuxeoConnectionTrackingCoordinator.class).error((Object)this.message(new StringBuilder()), (Throwable)this.info.getTrace());
                }
            }

            public StringBuilder message(StringBuilder builder) {
                return builder.append(this.info).append(",  was obtained by ").append(this.threadName).append(" at ").append(new Date(this.obtained)).append(" and timed out at ").append(new Date(this.deadline));
            }

            public String toString() {
                return String.format("TimeToLive(%x) %s", this.hashCode(), this.message(new StringBuilder()).toString());
            }
        }

        class CleanupTask
        extends TimerTask {
            CleanupTask() {
            }

            @Override
            public void run() {
                NuxeoConnectionManager.this.killActiveTimedoutConnections(System.currentTimeMillis());
            }
        }
    }

    static class InterceptorsImpl
    implements AbstractConnectionManager.Interceptors {
        private final ConnectionInterceptor stack;
        private final ConnectionInterceptor recoveryStack;
        private final PoolingSupport poolingSupport;

        public InterceptorsImpl(NuxeoValidationSupport validationSupport, TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, String name, ConnectionTracker connectionTracker, TransactionManager transactionManager, ClassLoader classLoader) {
            MCFConnectionInterceptor tail;
            this.poolingSupport = pooling;
            if (subjectSource == null && pooling instanceof PartitionedPool && ((PartitionedPool)pooling).isPartitionBySubject()) {
                throw new IllegalStateException("To use Subject in pooling, you need a SecurityDomain");
            }
            MCFConnectionInterceptor stack = tail = new MCFConnectionInterceptor();
            stack = transactionSupport.addXAResourceInsertionInterceptor((ConnectionInterceptor)stack, name);
            stack = pooling.addPoolingInterceptors((ConnectionInterceptor)stack);
            if (log.isTraceEnabled()) {
                log.trace("Connection Manager " + name + " installed pool " + stack);
            }
            stack = validationSupport.addValidationInterceptors((ConnectionInterceptor)stack);
            stack = transactionSupport.addTransactionInterceptors((ConnectionInterceptor)stack, transactionManager);
            if (subjectSource != null) {
                stack = new SubjectInterceptor((ConnectionInterceptor)stack, subjectSource);
            }
            this.recoveryStack = transactionSupport.isRecoverable() ? new TCCLInterceptor((ConnectionInterceptor)stack, classLoader) : null;
            stack = new ConnectionHandleInterceptor((ConnectionInterceptor)stack);
            stack = new TCCLInterceptor((ConnectionInterceptor)stack, classLoader);
            if (connectionTracker != null) {
                stack = new ConnectionTrackingInterceptor((ConnectionInterceptor)stack, name, connectionTracker);
            }
            tail.setStack((ConnectionInterceptor)stack);
            this.stack = stack;
            if (log.isDebugEnabled()) {
                StringBuilder s = new StringBuilder("ConnectionManager Interceptor stack;\n");
                stack.info(s);
                log.debug(s.toString());
            }
        }

        public ConnectionInterceptor getStack() {
            return this.stack;
        }

        public ConnectionInterceptor getRecoveryStack() {
            return this.recoveryStack;
        }

        public PoolingSupport getPoolingAttributes() {
            return this.poolingSupport;
        }
    }
}

