/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.tranql.connector.AbstractManagedConnection;

public class NuxeoValidationSupport {
    final Validation onBorrow;
    final Validation onReturn;
    static final Validation NOOP = new Validation(){

        @Override
        public boolean validate(ManagedConnection mc) {
            return true;
        }
    };

    NuxeoValidationSupport(Validation onBorrow, Validation onReturn) {
        this.onBorrow = onBorrow == null ? NOOP : onBorrow;
        this.onReturn = onReturn == null ? NOOP : onReturn;
    }

    public ConnectionInterceptor addValidationInterceptors(ConnectionInterceptor stack) {
        if (this.onBorrow == NOOP && this.onReturn == NOOP) {
            return stack;
        }
        return new ValidationInterceptor(stack);
    }

    class ValidationInterceptor
    implements ConnectionInterceptor {
        final ConnectionInterceptor next;

        public ValidationInterceptor(ConnectionInterceptor next) {
            this.next = next;
        }

        public void getConnection(ConnectionInfo ci) throws ResourceException {
            while (true) {
                this.next.getConnection(ci);
                if (NuxeoValidationSupport.this.onBorrow.validate(ci.getManagedConnectionInfo().getManagedConnection())) {
                    return;
                }
                LogFactory.getLog(NuxeoValidationSupport.class).warn((Object)("Returning invalid connection " + ci));
                this.returnConnection(ci, ConnectionReturnAction.DESTROY);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnConnection(ConnectionInfo info, ConnectionReturnAction returnAction) {
            if (returnAction == ConnectionReturnAction.RETURN_HANDLE && !NuxeoValidationSupport.this.onReturn.validate(info.getManagedConnectionInfo().getManagedConnection())) {
                returnAction = ConnectionReturnAction.DESTROY;
            }
            try {
                this.next.returnConnection(info, returnAction);
            }
            finally {
                if (returnAction == ConnectionReturnAction.DESTROY) {
                    ManagedConnectionInfo mci = info.getManagedConnectionInfo();
                    mci = new ManagedConnectionInfo(mci.getManagedConnectionFactory(), mci.getConnectionRequestInfo());
                    info.setManagedConnectionInfo(mci);
                }
            }
        }

        public void info(StringBuilder s) {
            this.next.info(s);
        }

        public void destroy() {
            this.next.destroy();
        }
    }

    public static class QuerySQLConnection
    implements Validation {
        final String sql;

        QuerySQLConnection(String sql) {
            this.sql = sql;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean validate(ManagedConnection mc) {
            AbstractManagedConnection jdbcManagedConnection = (AbstractManagedConnection)mc;
            try (Statement statement = ((Connection)jdbcManagedConnection.getPhysicalConnection()).createStatement();){
                boolean bl = statement.execute(this.sql);
                return bl;
            }
            catch (SQLException cause) {
                LogFactory.getLog(QuerySQLConnection.class).warn((Object)String.format("Caught error executing '%s', invalidating", this.sql), (Throwable)cause);
                return false;
            }
        }
    }

    public static class ValidSQLConnection
    implements Validation {
        @Override
        public boolean validate(ManagedConnection mc) {
            try {
                AbstractManagedConnection jdbcManagedConnection = (AbstractManagedConnection)mc;
                return ((Connection)jdbcManagedConnection.getPhysicalConnection()).isValid(0);
            }
            catch (SQLException cause) {
                return false;
            }
        }
    }

    public static interface Validation {
        public boolean validate(ManagedConnection var1);
    }
}

