/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.nuxeo.common.jndi.InitialContextAccessor;
import org.nuxeo.common.jndi.NamingContextFactory;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerFactory;
import org.nuxeo.runtime.jtajca.NuxeoTransactionManagerFactory;
import org.nuxeo.runtime.jtajca.NuxeoUserTransactionFactory;

public class NuxeoContainer {
    protected static final Log log = LogFactory.getLog(NuxeoContainer.class);
    public static final String JNDI_TRANSACTION_MANAGER = "java:comp/TransactionManager";
    public static final String JNDI_USER_TRANSACTION = "java:comp/UserTransaction";
    public static final String JNDI_NUXEO_CONNECTION_MANAGER = "java:comp/NuxeoConnectionManager";
    private static TransactionManagerWrapper transactionManager;
    private static final UserTransaction userTransaction;
    private static ConnectionManagerWrapper connectionManager;
    private static boolean isNamingOwner;
    private static Context namingContext;
    private static InstallContext installContext;

    private NuxeoContainer() {
    }

    public static void install() throws NamingException {
        NuxeoContainer.install(new TransactionManagerConfiguration(), new ConnectionManagerConfiguration());
    }

    public static synchronized void install(TransactionManagerConfiguration txconfig, ConnectionManagerConfiguration cmconfig) throws NamingException {
        if (installContext != null) {
            throw new Error("Nuxeo container already installed", installContext);
        }
        installContext = new InstallContext();
        transactionManager = NuxeoContainer.lookupTransactionManager();
        if (transactionManager == null) {
            NuxeoContainer.initTransactionManager(txconfig);
            NuxeoContainer.bind(JNDI_TRANSACTION_MANAGER, NuxeoContainer.getTransactionManagerReference());
            NuxeoContainer.bind(JNDI_USER_TRANSACTION, NuxeoContainer.getUserTransactionReference());
        }
        if ((connectionManager = NuxeoContainer.lookupConnectionManager()) == null) {
            NuxeoContainer.initConnectionManager(cmconfig);
            NuxeoContainer.bind(JNDI_NUXEO_CONNECTION_MANAGER, NuxeoContainer.getConnectionManagerReference());
        }
    }

    public static synchronized boolean isInstalled() {
        return installContext != null;
    }

    public static synchronized InstallContext getInstallContext() {
        return installContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void uninstall() throws NamingException {
        if (installContext == null) {
            throw new Error("Nuxeo container not installed");
        }
        installContext = null;
        try {
            NuxeoContainer.unbind(JNDI_TRANSACTION_MANAGER);
            NuxeoContainer.unbind(JNDI_USER_TRANSACTION);
            NuxeoContainer.unbind(JNDI_NUXEO_CONNECTION_MANAGER);
        }
        catch (Exception exception) {
        }
        finally {
            transactionManager = null;
            connectionManager = null;
        }
        NuxeoContainer.uninstallNaming();
    }

    private static void installNaming() throws NamingException {
        Context ctx = InitialContextAccessor.getInitialContext();
        if (ctx != null) {
            NamingContextFactory.setDelegateContext((Context)ctx);
            NamingContextFactory.setDelegateEnvironment(ctx.getEnvironment());
            log.warn((Object)"Chaining naming spaces, can break your application server");
        }
        NamingContextFactory.install();
        isNamingOwner = true;
        namingContext = new InitialContext();
        installContext = new InstallContext();
    }

    private static void uninstallNaming() throws NamingException {
        namingContext = null;
        installContext = null;
        if (!isNamingOwner) {
            return;
        }
        NamingContextFactory.revertSetAsInitial();
        isNamingOwner = false;
    }

    protected static void bind(String name, Reference ref) throws NamingException {
        if (namingContext == null) {
            namingContext = new InitialContext();
        }
        try {
            namingContext.rebind(name, (Object)ref);
        }
        catch (NamingException error) {
            NuxeoContainer.installNaming();
            namingContext.bind(name, (Object)ref);
        }
    }

    protected static void unbind(String name) throws NamingException {
        namingContext.unbind(name);
    }

    protected static <T> T jndiLookup(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            return (T)ctx.lookup("java:comp/" + name);
        }
        catch (NamingException compe) {
            try {
                return (T)ctx.lookup("java:comp/env/" + name);
            }
            catch (NamingException enve) {
                return (T)ctx.lookup(name);
            }
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    protected static Reference getTransactionManagerReference() {
        return new Reference(TransactionManager.class.getName(), NuxeoTransactionManagerFactory.class.getName(), null);
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        return userTransaction;
    }

    protected static Reference getUserTransactionReference() {
        return new Reference(UserTransaction.class.getName(), NuxeoUserTransactionFactory.class.getName(), null);
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    protected static Reference getConnectionManagerReference() {
        return new Reference(ConnectionManager.class.getName(), NuxeoConnectionManagerFactory.class.getName(), null);
    }

    public static synchronized void initTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        TransactionManager tm = NuxeoContainer.createTransactionManager(config);
        transactionManager = new TransactionManagerWrapper(tm);
    }

    protected static TransactionManagerWrapper lookupTransactionManager() {
        TransactionManager tm;
        try {
            tm = (TransactionManager)NuxeoContainer.jndiLookup("TransactionManager");
        }
        catch (NamingException e) {
            return null;
        }
        if (tm instanceof TransactionManagerWrapper) {
            return (TransactionManagerWrapper)tm;
        }
        return new TransactionManagerWrapper(tm);
    }

    public static synchronized void initConnectionManager(ConnectionManagerConfiguration config) throws NamingException {
        GenericConnectionManager cm = NuxeoContainer.createConnectionManager(config);
        connectionManager = new ConnectionManagerWrapper((AbstractConnectionManager)cm, config);
    }

    public static synchronized void resetConnectionManager() throws Exception {
        ConnectionManagerWrapper cm = connectionManager;
        if (cm == null) {
            return;
        }
        cm.reset();
    }

    protected static ConnectionManagerWrapper lookupConnectionManager() {
        ConnectionManager cm;
        try {
            cm = (ConnectionManager)NuxeoContainer.jndiLookup("NuxeoConnectionManager");
        }
        catch (NamingException e) {
            return null;
        }
        if (cm instanceof ConnectionManagerWrapper) {
            return (ConnectionManagerWrapper)cm;
        }
        log.warn((Object)"Connection manager not a wrapper, check your configuration");
        return null;
    }

    protected static TransactionManager createTransactionManager(TransactionManagerConfiguration config) {
        try {
            return new TransactionManagerImpl(config.transactionTimeoutSeconds);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected static GenericConnectionManager createConnectionManager(ConnectionManagerConfiguration config) throws NamingException {
        XATransactions transactionSupport = new XATransactions(config.useTransactionCaching, config.useThreadCaching);
        PartitionedPool poolingSupport = new PartitionedPool(config.maxPoolSize, config.minPoolSize, config.blockingTimeoutMillis, config.idleTimeoutMinutes, config.matchOne, config.matchAll, config.selectOneNoMatch, config.partitionByConnectionRequestInfo, config.partitionBySubject);
        final Subject subject = new Subject();
        SubjectSource subjectSource = new SubjectSource(){

            public Subject getSubject() {
                return subject;
            }
        };
        ConnectionTrackingCoordinator connectionTracker = new ConnectionTrackingCoordinator();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new GenericConnectionManager((TransactionSupport)transactionSupport, (PoolingSupport)poolingSupport, subjectSource, (ConnectionTracker)connectionTracker, (RecoverableTransactionManager)transactionManager, config.name, classLoader);
    }

    static {
        userTransaction = new UserTransactionImpl();
    }

    public static class ConnectionManagerConfiguration {
        public String name = "NuxeoConnectionManager";
        public boolean useTransactionCaching = true;
        public boolean useThreadCaching = true;
        public boolean matchOne = true;
        public boolean matchAll = true;
        public boolean selectOneNoMatch = false;
        public boolean partitionByConnectionRequestInfo = false;
        public boolean partitionBySubject = true;
        public int maxPoolSize = 20;
        public int minPoolSize = 0;
        public int blockingTimeoutMillis = 100;
        public int idleTimeoutMinutes = 0;

        public void setName(String name) {
            this.name = name;
        }

        public void setUseTransactionCaching(boolean useTransactionCaching) {
            this.useTransactionCaching = useTransactionCaching;
        }

        public void setUseThreadCaching(boolean useThreadCaching) {
            this.useThreadCaching = useThreadCaching;
        }

        public void setMatchOne(boolean matchOne) {
            this.matchOne = matchOne;
        }

        public void setMatchAll(boolean matchAll) {
            this.matchAll = matchAll;
        }

        public void setSelectOneNoMatch(boolean selectOneNoMatch) {
            this.selectOneNoMatch = selectOneNoMatch;
        }

        public void setPartitionByConnectionRequestInfo(boolean partitionByConnectionRequestInfo) {
            this.partitionByConnectionRequestInfo = partitionByConnectionRequestInfo;
        }

        public void setPartitionBySubject(boolean partitionBySubject) {
            this.partitionBySubject = partitionBySubject;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setMinPoolSize(int minPoolSize) {
            this.minPoolSize = minPoolSize;
        }

        public void setBlockingTimeoutMillis(int blockingTimeoutMillis) {
            this.blockingTimeoutMillis = blockingTimeoutMillis;
        }

        public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
        }
    }

    public static class ConnectionManagerWrapper
    implements ConnectionManager {
        private static final long serialVersionUID = 1L;
        protected AbstractConnectionManager cm;
        protected final ConnectionManagerConfiguration config;

        public ConnectionManagerWrapper(AbstractConnectionManager cm, ConnectionManagerConfiguration config) {
            this.cm = cm;
            this.config = config;
        }

        public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            return this.cm.allocateConnection(managedConnectionFactory, connectionRequestInfo);
        }

        public void reset() throws Exception {
            this.cm.doStop();
            this.cm = NuxeoContainer.createConnectionManager(this.config);
        }
    }

    public static class TransactionManagerWrapper
    implements RecoverableTransactionManager {
        protected TransactionManager tm;

        public TransactionManagerWrapper(TransactionManager tm) {
            this.tm = tm;
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.tm.setTransactionTimeout(seconds);
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.tm.resume(tobj);
        }

        public Transaction getTransaction() throws SystemException {
            return this.tm.getTransaction();
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.tm.commit();
        }

        public void begin() throws SystemException {
            try {
                this.tm.begin();
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void recoverResourceManager(NamedXAResource xaResource) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TransactionManagerConfiguration {
        public int transactionTimeoutSeconds = 600;

        public void setTransactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        }
    }

    public static class UserTransactionImpl
    implements UserTransaction {
        protected boolean checked;

        protected void check() throws SystemException {
            if (transactionManager != null) {
                return;
            }
            if (!this.checked) {
                this.checked = true;
                transactionManager = NuxeoContainer.lookupTransactionManager();
            }
            if (transactionManager == null) {
                throw new SystemException("No active transaction manager");
            }
        }

        public int getStatus() throws SystemException {
            this.check();
            return transactionManager.getStatus();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.check();
            transactionManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.check();
            transactionManager.setTransactionTimeout(seconds);
        }

        public void begin() throws NotSupportedException, SystemException {
            this.check();
            transactionManager.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.check();
            transactionManager.commit();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.check();
            transactionManager.rollback();
        }
    }

    public static class InstallContext
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final String threadName = Thread.currentThread().getName();

        InstallContext() {
            super("Container installation context (" + Thread.currentThread().getName() + ")");
        }
    }
}

