/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kv;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import net.jodah.expiringmap.ExpiringMap;
import org.nuxeo.runtime.kv.AbstractKeyValueStoreProvider;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;

public class MemKeyValueStore
extends AbstractKeyValueStoreProvider {
    protected final ExpiringMap<String, byte[]> map = ExpiringMap.builder().expiration(Integer.MAX_VALUE, TimeUnit.DAYS).variableExpiration().build();
    protected final Lock writeLock;
    protected String name;

    public MemKeyValueStore() {
        try {
            Field field = this.map.getClass().getDeclaredField("writeLock");
            field.setAccessible(true);
            this.writeLock = (Lock)field.get(this.map);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initialize(KeyValueStoreDescriptor descriptor) {
        this.name = descriptor.name;
    }

    @Override
    public Stream<String> keyStream() {
        return this.map.keySet().stream();
    }

    @Override
    public Stream<String> keyStream(String prefix) {
        return this.map.keySet().stream().filter(key -> key.startsWith(prefix));
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    protected static byte[] clone(byte[] value) {
        return value == null ? null : (byte[])value.clone();
    }

    @Override
    public void put(String key, byte[] value, long ttl) {
        Objects.requireNonNull(key);
        value = MemKeyValueStore.clone(value);
        if (value == null) {
            this.map.remove((Object)key);
        } else if (ttl == 0L) {
            this.map.put((Object)key, (Object)value);
        } else {
            this.map.put((Object)key, (Object)value, ttl, TimeUnit.SECONDS);
        }
    }

    @Override
    public byte[] get(String key) {
        Objects.requireNonNull(key);
        byte[] value = (byte[])this.map.get((Object)key);
        return MemKeyValueStore.clone(value);
    }

    @Override
    public boolean setTTL(String key, long ttl) {
        Objects.requireNonNull(key);
        byte[] value = (byte[])this.map.get((Object)key);
        if (value == null) {
            return false;
        }
        this.doSetTTL(key, ttl);
        return true;
    }

    protected void doSetTTL(String key, long ttl) {
        if (ttl == 0L) {
            this.map.setExpiration((Object)key, Integer.MAX_VALUE, TimeUnit.DAYS);
        } else {
            this.map.setExpiration((Object)key, ttl, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSet(String key, byte[] expected, byte[] value, long ttl) {
        Objects.requireNonNull(key);
        value = MemKeyValueStore.clone(value);
        this.writeLock.lock();
        try {
            byte[] current = (byte[])this.map.get((Object)key);
            boolean equal = Arrays.equals(expected, current);
            if (equal) {
                if (value == null) {
                    this.map.remove((Object)key);
                } else {
                    this.map.put((Object)key, (Object)value);
                    this.doSetTTL(key, ttl);
                }
            }
            boolean bl = equal;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ")";
    }
}

