/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.nuxeo.osgi.application.MutableClassLoader;

public class MutableClassLoaderDelegate
implements MutableClassLoader {
    protected ClassLoader cl;
    protected Method addURL;

    public MutableClassLoaderDelegate(ClassLoader delegate) {
        this.addURL = this.urlSetter(delegate);
        if (this.addURL == null) {
            delegate = new URLClassLoader(new URL[0], delegate);
            this.addURL = this.urlSetter(delegate);
        }
        this.addURL.setAccessible(true);
        this.cl = delegate;
    }

    private Method urlSetter(ClassLoader cl) {
        Class<?> clazz = cl.getClass();
        do {
            try {
                return clazz.getDeclaredMethod("addURL", URL.class);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to adapt class loader: " + cl.getClass(), e);
            }
        } while (clazz != null);
        return null;
    }

    @Override
    public void addURL(URL url) {
        try {
            this.addURL.invoke((Object)this.cl, url);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add URL to class loader: " + url, e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }
}

