/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.nuxeo.runtime.management.ManagementRuntimeException;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.management.ServerLocatorDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ServerLocatorService
extends DefaultComponent
implements ServerLocator {
    public static final String LOCATORS_EXT_KEY = "locators";
    protected Map<String, MBeanServer> otherServers = new HashMap<String, MBeanServer>();
    protected MBeanServer defaultServer = ManagementFactory.getPlatformMBeanServer();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(LOCATORS_EXT_KEY)) {
            this.doRegisterLocator((ServerLocatorDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(LOCATORS_EXT_KEY)) {
            this.doUnregisterLocator((ServerLocatorDescriptor)contribution);
        }
    }

    protected void doRegisterLocator(ServerLocatorDescriptor descriptor) {
        String domainName = descriptor.getDomainName();
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.getDefaultDomain().equals(domainName)) continue;
            this.otherServers.put(domainName, server);
            if (descriptor.isDefaultServer) {
                this.defaultServer = server;
            }
            return;
        }
        throw new ManagementRuntimeException("cannot locate mbean server containing domain " + domainName);
    }

    protected void doUnregisterLocator(ServerLocatorDescriptor descriptor) {
        this.otherServers.remove(descriptor.domainName);
        if (descriptor.isDefaultServer) {
            this.defaultServer = ManagementFactory.getPlatformMBeanServer();
        }
    }

    public MBeanServer lookupServer(ObjectName qualifiedName) {
        if (this.defaultServer.isRegistered(qualifiedName)) {
            return this.defaultServer;
        }
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.isRegistered(qualifiedName)) continue;
            return server;
        }
        throw new ManagementRuntimeException(qualifiedName + " is not registered");
    }

    public MBeanServer lookupServer() {
        return this.defaultServer;
    }

    public MBeanServer lookupServer(String domainName) {
        if (this.otherServers.containsKey(domainName)) {
            return this.otherServers.get(domainName);
        }
        return this.defaultServer;
    }

    public void registerLocator(String domain, boolean isDefault) {
        this.doRegisterLocator(new ServerLocatorDescriptor(domain, isDefault));
    }
}

