/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.inspector;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.XMLParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsesoft.mmbi.JMX;
import org.jsesoft.mmbi.JMXNotification;
import org.jsesoft.ri.InspectorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMBeanInspectorStrategy
extends InspectorSupport {
    private static final transient Log log = LogFactory.getLog(ModelMBeanInspectorStrategy.class);
    private Descriptor mbeanDescriptor;
    private ModelMBeanInfo mbeanInfo;
    private BeanInfo beanInfo;
    private Vector<ModelMBeanConstructorInfo> constructorInfos = new Vector();
    private Vector<ModelMBeanOperationInfo> operationInfos = new Vector();
    private Vector<ModelMBeanAttributeInfo> attributeInfos = new Vector();
    private Vector<ModelMBeanNotificationInfo> notificationInfos = new Vector();
    private final ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[0];
    private final ModelMBeanOperationInfo[] operations = new ModelMBeanOperationInfo[0];
    private final ModelMBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[0];
    private final ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[0];
    private final Class<?> sentinel;
    private static final Pattern attributePattern = Pattern.compile("(get|set|is)(.*)");

    public ModelMBeanInspectorStrategy(Class<?> inspected) throws IntrospectionException {
        this.sentinel = inspected.isInterface() ? null : Object.class;
        this.beanInfo = Introspector.getBeanInfo(inspected);
    }

    public boolean inspect(Class<?> inspected) throws Exception {
        Descriptor descriptor;
        if (inspected.equals(this.sentinel)) {
            return true;
        }
        BeanInfo oldBeanInfo = this.beanInfo;
        this.beanInfo = Introspector.getBeanInfo(inspected, this.sentinel);
        this.handleJMXNotificationAnnotations(inspected.getAnnotations());
        JMX annotation = inspected.getAnnotation(JMX.class);
        this.mbeanDescriptor = descriptor = this.getDescriptor(annotation, this.beanInfo.getBeanDescriptor(), inspected.getName(), inspected.getSimpleName(), inspected.getCanonicalName(), "MBean");
        if (log.isDebugEnabled()) {
            log.debug((Object)((DescriptorSupport)descriptor).toXMLString());
        }
        this.beanInfo = oldBeanInfo;
        return false;
    }

    public boolean inspectConstructor(Class<?> inspected, Constructor<?> constructor) throws Exception {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return false;
        }
        this.handleJMXNotificationAnnotations(constructor.getAnnotations());
        JMX annotation = constructor.getAnnotation(JMX.class);
        if (annotation != null && annotation.hide()) {
            return false;
        }
        MBeanParameterInfo[] parameterInfos = this.getParameterInfos(constructor.getParameterTypes(), constructor.getParameterAnnotations(), null);
        String name = constructor.getName();
        Descriptor descriptor = this.getDescriptor(annotation, null, name, name, name, "operation");
        descriptor.setField("role", "constructor");
        this.constructorInfos.add(new ModelMBeanConstructorInfo((String)descriptor.getFieldValue("name"), (String)descriptor.getFieldValue("description"), parameterInfos, descriptor));
        if (log.isDebugEnabled()) {
            log.debug((Object)((DescriptorSupport)descriptor).toXMLString());
        }
        return false;
    }

    public boolean inspectMethod(Class<?> inspected, Method operation) throws Exception {
        int impact;
        if (!Modifier.isPublic(operation.getModifiers())) {
            return false;
        }
        this.handleJMXNotificationAnnotations(operation.getAnnotations());
        JMX annotation = operation.getAnnotation(JMX.class);
        if (annotation != null && annotation.hide()) {
            return false;
        }
        MethodDescriptor methodDescriptor = this.getMethodDescriptor(this.beanInfo.getMethodDescriptors(), operation);
        ParameterDescriptor[] parameterDescriptors = methodDescriptor == null ? null : methodDescriptor.getParameterDescriptors();
        MBeanParameterInfo[] parameterInfos = this.getParameterInfos(operation.getParameterTypes(), operation.getParameterAnnotations(), parameterDescriptors);
        String name = operation.getName();
        Descriptor descriptor = this.getDescriptor(annotation, methodDescriptor, name, name, name, "operation");
        descriptor.setField("class", inspected.getName());
        descriptor.setField("displayName", descriptor.getFieldValue("name"));
        if (operation.getName().startsWith("get") && operation.getParameterTypes().length == 0 && operation.getReturnType() != null || operation.getName().startsWith("is") && operation.getParameterTypes().length == 0 && Boolean.TYPE.equals(operation.getReturnType())) {
            this.doFixAttribute(inspected, operation.getName());
            descriptor.setField("role", "getter");
        } else if (operation.getName().startsWith("set") && Void.TYPE.equals(operation.getReturnType()) && operation.getParameterTypes().length == 0 && operation.getReturnType() != null) {
            this.doFixAttribute(inspected, operation.getName());
            descriptor.setField("role", "setter");
        } else {
            descriptor.setField("role", "operation");
        }
        int n = impact = annotation == null ? 2 : annotation.impact();
        if (impact == 3) {
            impact = 2;
        }
        this.operationInfos.add(new ModelMBeanOperationInfo((String)descriptor.getFieldValue("name"), (String)descriptor.getFieldValue("description"), parameterInfos, operation.getReturnType().getName(), impact, descriptor));
        if (log.isDebugEnabled()) {
            log.debug((Object)((DescriptorSupport)descriptor).toXMLString());
        }
        return false;
    }

    private MBeanParameterInfo[] getParameterInfos(Class<?>[] types, Annotation[][] annotations, ParameterDescriptor[] features) {
        if (types.length == 0) {
            return new MBeanParameterInfo[0];
        }
        MBeanParameterInfo[] parameterInfos = new MBeanParameterInfo[types.length];
        for (int iX = 0; iX < types.length; ++iX) {
            String description;
            String name;
            Class<?> type = types[iX];
            JMX annotation = this.getJMXAnnotation(annotations[iX]);
            String string = name = features == null ? null : features[iX].getName();
            if (name == null) {
                name = "p" + iX;
            }
            String string2 = description = features == null ? null : features[iX].getShortDescription();
            if (description == null) {
                String string3 = description = annotation == null ? "" : annotation.description();
            }
            if ("".equals(description)) {
                description = name;
            }
            parameterInfos[iX] = new MBeanParameterInfo(name, type.getName(), description);
        }
        return parameterInfos;
    }

    public MethodDescriptor getMethodDescriptor(MethodDescriptor[] features, Method method) {
        for (MethodDescriptor feature : features) {
            if (!feature.getMethod().equals(method)) continue;
            return feature;
        }
        return null;
    }

    public boolean inspectField(Class<?> inspected, Field field) throws Exception {
        JMX annotation = field.getAnnotation(JMX.class);
        if (annotation != null && annotation.hide()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(this.beanInfo.getPropertyDescriptors(), field);
        Method getter = null;
        if (propertyDescriptor != null) {
            getter = propertyDescriptor.getReadMethod();
        }
        if (getter == null) {
            getter = this.getGetter(inspected, field);
        }
        Method setter = null;
        if (propertyDescriptor != null) {
            setter = propertyDescriptor.getWriteMethod();
        }
        if (setter == null) {
            setter = this.getSetter(inspected, field);
        }
        if (setter == null && getter == null) {
            return false;
        }
        String name = field.getName();
        Descriptor descriptor = this.getDescriptor(annotation, propertyDescriptor, name, name, name, "attribute");
        if (getter != null) {
            descriptor.setField("getMethod", getter.getName());
        }
        if (setter != null) {
            descriptor.setField("setMethod", setter.getName());
        }
        this.attributeInfos.add(new ModelMBeanAttributeInfo((String)descriptor.getFieldValue("name"), (String)descriptor.getFieldValue("description"), getter, setter, descriptor));
        if (log.isDebugEnabled()) {
            log.debug((Object)((DescriptorSupport)descriptor).toXMLString());
        }
        return false;
    }

    public PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] features, Field field) {
        for (PropertyDescriptor feature : features) {
            if (!feature.getName().equals(field.getName())) continue;
            return feature;
        }
        return null;
    }

    public Method getGetter(Class<?> inspected, Field field) {
        String name = field.getName();
        String upper = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : inspected.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (Boolean.TYPE.equals(field.getType()) && Boolean.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0 && ("is" + upper).equals(method.getName())) {
                return method;
            }
            if (!field.getType().equals(method.getReturnType()) || method.getParameterTypes().length != 0 || !("get" + upper).equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public Method getSetter(Class<?> inspected, Field field) {
        String name = field.getName();
        String upper = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : inspected.getDeclaredMethods()) {
            Class<?>[] types;
            if (!Modifier.isPublic(method.getModifiers()) || (types = method.getParameterTypes()).length != 1 || !field.getType().equals(types[0]) || !("set" + upper).equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public JMX getJMXAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(JMX.class)) continue;
            return (JMX)annotation;
        }
        return null;
    }

    public void handleJMXNotificationAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(JMXNotification.class)) continue;
            JMXNotification notification = (JMXNotification)annotation;
            DescriptorSupport descriptor = new DescriptorSupport();
            descriptor.setField("name", notification.name());
            descriptor.setField("displayName", notification.displayName());
            descriptor.setField("description", notification.description());
            descriptor.setField("severity", notification.severity());
            descriptor.setField("descriptorType", "notification");
            if (this.notificationInfos == null) {
                this.notificationInfos = new Vector();
            }
            this.notificationInfos.add(new ModelMBeanNotificationInfo(notification.types(), notification.name(), notification.description(), descriptor));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)descriptor.toXMLString());
        }
    }

    public Descriptor getDescriptor(JMX annotation, FeatureDescriptor feature, String defaultName, String defaultDisplayName, String defaultDescription, String descriptorType) throws MBeanException, XMLParseException {
        DescriptorSupport descriptor;
        if (annotation != null) {
            String xml = annotation.xml();
            if ("".equals(xml)) {
                descriptor = new DescriptorSupport();
                descriptor.setField("name", defaultName);
            } else {
                descriptor = new DescriptorSupport(xml);
            }
        } else {
            descriptor = new DescriptorSupport();
            descriptor.setField("name", defaultName);
        }
        descriptor.setField("descriptorType", descriptorType);
        String name = (String)descriptor.getFieldValue("name");
        if (feature != null && feature.getName() != null) {
            name = feature.getName();
        }
        if (annotation != null && !"".equals(annotation.name())) {
            name = annotation.name();
        }
        String displayName = (String)descriptor.getFieldValue("displayName");
        if (feature != null && feature.getDisplayName() != null) {
            displayName = feature.getDisplayName();
        }
        if (annotation != null && !"".equals(annotation.displayName())) {
            displayName = annotation.displayName();
        }
        if (displayName == null || "".equals(displayName)) {
            displayName = defaultDisplayName;
        }
        String description = (String)descriptor.getFieldValue("description");
        if (feature != null && feature.getShortDescription() != null) {
            description = feature.getShortDescription();
        }
        if (annotation != null && !"".equals(annotation.description())) {
            description = annotation.description();
        }
        if (description == null || "".equals(description)) {
            description = defaultDescription;
        }
        descriptor.setField("name", name);
        descriptor.setField("displayName", displayName);
        descriptor.setField("description", description);
        return descriptor;
    }

    public ModelMBeanConstructorInfo[] getConstructorInfos() {
        if (this.constructorInfos == null) {
            return new ModelMBeanConstructorInfo[0];
        }
        return this.constructorInfos.toArray(this.constructors);
    }

    public ModelMBeanOperationInfo[] getOperationInfos() {
        if (this.operationInfos == null) {
            return new ModelMBeanOperationInfo[0];
        }
        return this.operationInfos.toArray(this.operations);
    }

    public ModelMBeanAttributeInfo[] getAttributeInfos() {
        if (this.attributeInfos == null) {
            return new ModelMBeanAttributeInfo[0];
        }
        return this.attributeInfos.toArray(this.attributes);
    }

    public ModelMBeanNotificationInfo[] getNotificationInfos() {
        if (this.notificationInfos == null) {
            return new ModelMBeanNotificationInfo[0];
        }
        return this.notificationInfos.toArray(this.notifications);
    }

    public ModelMBeanInfo getMBeanInfo() {
        if (this.mbeanInfo != null) {
            return this.mbeanInfo;
        }
        this.mbeanInfo = new ModelMBeanInfoSupport((String)this.mbeanDescriptor.getFieldValue("name"), (String)this.mbeanDescriptor.getFieldValue("description"), this.getAttributeInfos(), this.getConstructorInfos(), this.getOperationInfos(), this.getNotificationInfos(), this.mbeanDescriptor);
        return this.mbeanInfo;
    }

    protected String doExtractMethodSuffix(String operationName) {
        Matcher matcher = attributePattern.matcher(operationName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(operationName + " does not match");
        }
        return matcher.group(2);
    }

    protected boolean hasAttributeInfo(String attributeName) {
        for (ModelMBeanAttributeInfo attributeInfo : this.attributeInfos) {
            if (!attributeInfo.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    protected void doFixAttribute(Class<?> inspected, String operationName) throws Exception {
        String methodSuffix = this.doExtractMethodSuffix(operationName);
        String attributeName = methodSuffix.substring(0, 1).toLowerCase() + methodSuffix.substring(1);
        if (this.hasAttributeInfo(attributeName)) {
            return;
        }
        Method reader = null;
        Method writter = null;
        for (Method method : inspected.getMethods()) {
            Matcher matcher = attributePattern.matcher(method.getName());
            if (!matcher.matches() || !matcher.group(2).equals(methodSuffix)) continue;
            String prefix = matcher.group(1);
            if (prefix.equals("is")) {
                if (reader != null) continue;
                reader = method;
                continue;
            }
            if (prefix.equals("get")) {
                reader = method;
                continue;
            }
            if (!prefix.equals("set")) continue;
            writter = method;
        }
        Descriptor descriptor = this.getDescriptor(null, null, attributeName, null, null, "attribute");
        if (reader != null) {
            descriptor.setField("getMethod", reader.getName());
        }
        if (writter != null) {
            descriptor.setField("setMethod", writter.getName());
        }
        if (this.attributeInfos == null) {
            this.attributeInfos = new Vector();
        }
        this.attributeInfos.add(new ModelMBeanAttributeInfo(attributeName, attributeName, reader, writter, descriptor));
        if (log.isDebugEnabled()) {
            log.debug((Object)((DescriptorSupport)descriptor).toXMLString());
        }
    }
}

