/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.inspector;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.nuxeo.runtime.management.ManagementRuntimeException;

public class ModelMBeanIntrospector {
    protected final Class<?> clazz;
    protected ModelMBeanInfo managementInfo;
    protected final Map<String, ModelMBeanAttributeInfo> attributesInfo = new HashMap<String, ModelMBeanAttributeInfo>();
    protected final Map<String, ModelMBeanConstructorInfo> constructorsInfo = new HashMap<String, ModelMBeanConstructorInfo>();
    protected final Map<String, ModelMBeanOperationInfo> operationsInfo = new HashMap<String, ModelMBeanOperationInfo>();
    protected final Map<String, ModelMBeanNotificationInfo> notificationsInfo = new HashMap<String, ModelMBeanNotificationInfo>();
    private final Pattern attributePattern = Pattern.compile("(get|set|is)(.*)");

    public ModelMBeanIntrospector(Class<?> clazz) {
        this.clazz = clazz;
    }

    ModelMBeanInfo introspect() {
        if (this.managementInfo != null) {
            return this.managementInfo;
        }
        ArrayList<Class> ifaces = new ArrayList<Class>(1);
        if (this.clazz.isInterface()) {
            ifaces.add(this.clazz);
        } else {
            this.doCollectIfaces(ifaces, this.clazz);
        }
        for (Class iface : ifaces) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(iface);
            }
            catch (IntrospectionException e) {
                throw ManagementRuntimeException.wrap("Cannot introspect " + iface, e);
            }
            this.doCollectAttributes(iface, beanInfo);
            this.doCollectConstructors(iface, beanInfo);
            this.doCollectOperations(iface, beanInfo);
            this.doCollectNotifications(iface, beanInfo);
        }
        this.managementInfo = new ModelMBeanInfoSupport(this.clazz.getCanonicalName(), "", this.attributesInfo.values().toArray(new ModelMBeanAttributeInfo[this.attributesInfo.size()]), this.constructorsInfo.values().toArray(new ModelMBeanConstructorInfo[this.constructorsInfo.size()]), this.operationsInfo.values().toArray(new ModelMBeanOperationInfo[this.operationsInfo.size()]), this.notificationsInfo.values().toArray(new ModelMBeanNotificationInfo[this.notificationsInfo.size()]));
        return this.managementInfo;
    }

    protected void doCollectIfaces(List<Class> ifaces, Class clazz) {
        for (Class<?> iface : clazz.getInterfaces()) {
            if (iface.getName().endsWith("MBean")) {
                ifaces.clear();
                ifaces.add(iface);
                return;
            }
            ifaces.add(iface);
        }
    }

    protected void doCollectNotifications(Class<?> clazz, BeanInfo info) {
    }

    protected void doCollectAttributes(Class<?> clazz, BeanInfo beanInfo) {
        for (PropertyDescriptor propertyInfo : beanInfo.getPropertyDescriptors()) {
            if (propertyInfo.isHidden()) continue;
            ModelMBeanAttributeInfo attributeInfo = null;
            try {
                Descriptor descriptor = this.doGetDescriptor(propertyInfo, "attribute");
                Method readMethod = propertyInfo.getReadMethod();
                Method writeMethod = propertyInfo.getWriteMethod();
                if (readMethod != null) {
                    descriptor.setField("getMethod", readMethod.getName());
                }
                if (writeMethod != null) {
                    descriptor.setField("setMethod", writeMethod.getName());
                }
                attributeInfo = new ModelMBeanAttributeInfo(propertyInfo.getName(), propertyInfo.getShortDescription(), propertyInfo.getReadMethod(), propertyInfo.getWriteMethod(), descriptor);
            }
            catch (javax.management.IntrospectionException e) {
                continue;
            }
            this.attributesInfo.put(attributeInfo.getName(), attributeInfo);
        }
    }

    protected void doCollectConstructors(Class<?> clazz, BeanInfo info) {
    }

    protected void doCollectOperations(Class<?> clazz, BeanInfo beanInfo) {
        for (MethodDescriptor methodInfo : beanInfo.getMethodDescriptors()) {
            boolean returnValue;
            if (methodInfo.isHidden()) continue;
            Descriptor descriptor = this.doGetDescriptor(methodInfo, "operation");
            String name = methodInfo.getName();
            Method method = methodInfo.getMethod();
            ParameterDescriptor[] parameters = methodInfo.getParameterDescriptors();
            boolean hasParameters = parameters != null && parameters.length > 0;
            Class<?> returnType = method.getReturnType();
            boolean bl = returnValue = returnType != null && !Void.TYPE.equals(returnType);
            if (name.startsWith("get") && hasParameters && returnValue || name.startsWith("is") && !hasParameters && Boolean.TYPE.equals(returnType)) {
                descriptor.setField("role", "getter");
            } else if (methodInfo.getName().startsWith("set") && Void.TYPE.equals(returnType) && hasParameters && parameters.length == 1) {
                descriptor.setField("role", "setter");
            } else {
                descriptor.setField("role", "operation");
            }
            ModelMBeanOperationInfo operationInfo = new ModelMBeanOperationInfo(methodInfo.getShortDescription(), methodInfo.getMethod(), descriptor);
            this.operationsInfo.put(operationInfo.getName(), operationInfo);
        }
    }

    protected Descriptor doGetDescriptor(FeatureDescriptor info, String descriptorType) {
        DescriptorSupport descriptor = new DescriptorSupport();
        descriptor.setField("name", info.getName());
        descriptor.setField("displayName", info.getDisplayName());
        descriptor.setField("description", info.getShortDescription());
        descriptor.setField("descriptorType", descriptorType);
        return descriptor;
    }

    protected String doExtractMethodSuffix(String operationName) {
        Matcher matcher = this.attributePattern.matcher(operationName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(operationName + " does not match");
        }
        return matcher.group(2);
    }
}

