/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.osgi.BundleIdGenerator;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.BundleRegistry;
import org.nuxeo.osgi.SystemBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;

public class OSGiAdapter {
    private static final Log log = LogFactory.getLog(OSGiAdapter.class);
    protected final File workingDir;
    protected final File idTableFile;
    protected final BundleIdGenerator bundleIds;
    protected ListenerList frameworkListeners;
    protected ListenerList bundleListeners;
    protected ListenerList serviceListeners;
    protected Map<String, Bundle> bundles;
    protected Map<String, ServiceRegistration> services;
    protected BundleRegistry registry;
    protected Properties properties;
    protected SystemBundle systemBundle;

    public OSGiAdapter(File workingDir) {
        this.workingDir = workingDir;
        this.properties = new Properties();
        this.registry = new BundleRegistry();
        this.frameworkListeners = new ListenerList();
        this.bundleListeners = new ListenerList();
        this.serviceListeners = new ListenerList();
        this.bundleIds = new BundleIdGenerator();
        this.idTableFile = new File(workingDir, "bundles.ids");
        this.bundleIds.load(this.idTableFile);
        this.properties.put("org.osgi.framework.vendor", "Nuxeo");
        this.properties.put("org.osgi.framework.version", "1.0.0");
    }

    public void setSystemBundle(SystemBundle systemBundle) throws BundleException {
        if (this.systemBundle != null) {
            throw new IllegalStateException("Cannot set system bundle");
        }
        this.install(systemBundle);
        this.registry.addBundleAlias("system.bundle", systemBundle.getSymbolicName());
        this.systemBundle = systemBundle;
    }

    public BundleRegistry getRegistry() {
        return this.registry;
    }

    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void shutdown() throws IOException {
        this.bundleIds.store(this.idTableFile);
        this.registry.shutdown();
        this.properties.clear();
        this.registry = null;
        this.frameworkListeners = null;
        this.bundleListeners = null;
        this.serviceListeners = null;
        this.properties = null;
    }

    public long getBundleId(String symbolicName) {
        return this.bundleIds.getBundleId(symbolicName);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public BundleImpl[] getInstalledBundles() {
        return this.registry.getInstalledBundles();
    }

    public void install(BundleImpl bundle) throws BundleException {
        this.registry.install(bundle);
    }

    public void uninstall(BundleImpl bundle) throws BundleException {
        this.registry.uninstall(bundle);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.frameworkListeners.add((Object)listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.frameworkListeners.remove((Object)listener);
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceListeners.add((Object)listener);
    }

    public void addServiceListener(ServiceListener listener, String filter) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceListeners.remove((Object)listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.bundleListeners.add((Object)listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.bundleListeners.remove((Object)listener);
    }

    public void fireFrameworkEvent(FrameworkEvent event) {
        Object[] listeners;
        for (Object listener : listeners = this.frameworkListeners.getListeners()) {
            ((FrameworkListener)listener).frameworkEvent(event);
        }
    }

    public void fireServiceEvent(ServiceEvent event) {
        Object[] listeners;
        for (Object listener : listeners = this.serviceListeners.getListeners()) {
            ((ServiceListener)listener).serviceChanged(event);
        }
    }

    public void fireBundleEvent(BundleEvent event) {
        Object[] listeners;
        for (Object listener : listeners = this.bundleListeners.getListeners()) {
            ((BundleListener)listener).bundleChanged(event);
        }
    }

    public Bundle getSystemBundle() {
        return this.systemBundle;
    }
}

