/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.launcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.runtime.launcher.BundleFile;
import org.nuxeo.runtime.launcher.StandaloneBundleLoader;

public class RuntimeLoader {
    public static final String EXTRACT_NESTED_JARS = "org.nuxeo.runtime.loader.extractNestedJARs";
    public static final String SCAN_FOR_NESTED_JARS = "org.nuxeo.runtime.loader.scanForNestedJARs";
    public static final String LIB_DIR = "org.nuxeo.runtime.loader.lib";
    public static final String DATA_DIR = "org.nuxeo.runtime.loader.data";
    public static final String BUNDLES_DIR = "org.nuxeo.runtime.loader.bundles";
    public static final String CONFIG_DIR = "org.nuxeo.runtime.loader.config";
    private final Properties properties = new Properties();
    private StandaloneBundleLoader bundleLoader;

    public RuntimeLoader() {
    }

    public RuntimeLoader(File configFile) {
        this.setProperties(configFile);
    }

    public RuntimeLoader(Properties properties) {
        this.setProperties(properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            this.properties.clear();
        } else {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    public void setProperties(File cfg) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(cfg));
            this.properties.load(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StandaloneBundleLoader getBundleLoader() {
        return this.bundleLoader;
    }

    public File getDataDir() {
        return new File(this.properties.getProperty(DATA_DIR, "data"));
    }

    public File getConfigDir() {
        return new File(this.properties.getProperty(CONFIG_DIR, "config"));
    }

    public File getLibDir() {
        return new File(this.properties.getProperty(LIB_DIR, "lib"));
    }

    public File getBundlesDir() {
        return new File(this.properties.getProperty(BUNDLES_DIR, "bundles"));
    }

    public ClassLoader loadRuntime() throws Exception {
        return this.loadRuntime(RuntimeLoader.class.getClassLoader());
    }

    public ClassLoader loadRuntime(ClassLoader parentLoader) throws Exception {
        boolean extractNestedJARs = Boolean.parseBoolean(this.properties.getProperty(EXTRACT_NESTED_JARS, "true"));
        boolean scanNestedJARs = Boolean.parseBoolean(this.properties.getProperty(SCAN_FOR_NESTED_JARS, "true"));
        File data = this.getDataDir();
        File config = this.getConfigDir();
        File libsDir = this.getLibDir();
        File bundlesDir = this.getBundlesDir();
        OSGiAdapter osgi = new OSGiAdapter(data);
        osgi.setProperty("CONFIG_DIR", config.getAbsolutePath());
        this.bundleLoader = new StandaloneBundleLoader(osgi, parentLoader);
        Thread.currentThread().setContextClassLoader(this.bundleLoader.getSharedClassLoader());
        this.bundleLoader.setScanForNestedJARs(scanNestedJARs);
        this.bundleLoader.setExtractNestedJARs(extractNestedJARs);
        ArrayList<BundleFile> bundles = new ArrayList<BundleFile>();
        ArrayList<BundleFile> jars = new ArrayList<BundleFile>();
        if (libsDir.isDirectory()) {
            this.bundleLoader.load(libsDir, bundles, jars);
        }
        if (bundlesDir.isDirectory()) {
            this.bundleLoader.load(bundlesDir, bundles, jars);
        }
        this.bundleLoader.installAll(bundles);
        return this.bundleLoader.getSharedClassLoader();
    }
}

