/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.launcher;

import java.io.File;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.nuxeo.common.utils.FileNamePattern;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.runtime.launcher.BundleFile;
import org.nuxeo.runtime.launcher.DirectoryBundleFile;
import org.nuxeo.runtime.launcher.FileWalker;
import org.nuxeo.runtime.launcher.JarBundleFile;

public class BundleVisitor
extends FileWalker.Visitor {
    public static final FileNamePattern[] DEFAULT_PATTERNS = new FileNamePattern[]{new FileNamePattern("*.jar"), new FileNamePattern("*.war"), new FileNamePattern("*.rar"), new FileNamePattern("*.sar"), new FileNamePattern("*_jar"), new FileNamePattern("*_war"), new FileNamePattern("*_rar")};
    private FileNamePattern[] patterns;
    private final Callback callback;

    public BundleVisitor(Callback cb) {
        this(cb, DEFAULT_PATTERNS);
    }

    public BundleVisitor(Callback cb, String[] patterns) {
        if (patterns != null) {
            this.patterns = new FileNamePattern[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                this.patterns[i] = new FileNamePattern(patterns[i]);
            }
        }
        this.callback = cb;
    }

    public BundleVisitor(Callback cb, FileNamePattern[] patterns) {
        this.patterns = patterns;
        this.callback = cb;
    }

    public void visit(File root) {
        new FileWalker().walk(root, this);
    }

    public int visitDirectory(File file) {
        String fileName = file.getName();
        if (this.patterns != null && !this.acceptFile(fileName, this.patterns)) {
            return 0;
        }
        try {
            Manifest mf = JarUtils.getDirectoryManifest((File)file);
            if (mf == null) {
                return 0;
            }
            String bundleName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bundleName != null) {
                this.callback.visitBundle(new DirectoryBundleFile(file, mf));
                return 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int visitFile(File file) {
        String fileName = file.getName();
        if (this.patterns != null && !this.acceptFile(fileName, this.patterns)) {
            return 0;
        }
        try {
            JarFile jarFile = new JarFile(file);
            if (jarFile.getManifest() == null) {
                return 0;
            }
            JarBundleFile bundleFile = new JarBundleFile(jarFile);
            if (bundleFile.getSymbolicName() != null) {
                this.callback.visitBundle(bundleFile);
            } else {
                this.callback.visitJar(bundleFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected boolean acceptFile(String fileName, FileNamePattern[] patterns) {
        int i;
        for (i = 0; i < patterns.length && !patterns[i].match(fileName); ++i) {
        }
        return i < patterns.length;
    }

    public static interface Callback {
        public void visitBundle(BundleFile var1) throws Exception;

        public void visitJar(BundleFile var1) throws Exception;
    }
}

