/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    protected boolean scanForNestedJARs = true;
    protected final Callback callback;

    public ClassPathScanner(Callback callback) {
        this.callback = callback;
    }

    public ClassPathScanner(Callback callback, boolean scanForNestedJars) {
        this.callback = callback;
        this.scanForNestedJARs = scanForNestedJars;
    }

    public void setScanForNestedJARs(boolean scanForNestedJars) {
        this.scanForNestedJARs = scanForNestedJars;
    }

    public void scan(List<File> classPath) {
        for (File file : classPath) {
            this.scan(file);
        }
    }

    public void scan(File file) {
        String name = file.getName();
        if (!(name.endsWith(".jar") || name.endsWith(".rar") || name.endsWith(".sar") || name.endsWith("_jar") || name.endsWith("_rar") || name.endsWith("_sar"))) {
            return;
        }
        BundleFile bf = null;
        try {
            if (file.isFile()) {
                JarFile jar = new JarFile(file);
                bf = new JarBundleFile(jar);
            } else if (file.isDirectory()) {
                bf = new DirectoryBundleFile(file);
            } else {
                return;
            }
            Collection<BundleFile> nested = null;
            File nestedJARsDir = null;
            nestedJARsDir = bf.getSymbolicName() == null ? this.callback.handleJar(bf) : this.callback.handleBundle(bf);
            if (nestedJARsDir != null && (nested = this.extractNestedJars(bf, nestedJARsDir)) != null) {
                for (BundleFile nestedJar : nested) {
                    this.callback.handleNestedJar(nestedJar);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Collection<BundleFile> extractNestedJars(BundleFile bf, File nestedBundlesDir) throws IOException {
        Collection<BundleFile> bundles = null;
        bundles = this.scanForNestedJARs ? bf.findNestedBundles(nestedBundlesDir) : bf.getNestedBundles(nestedBundlesDir);
        if (bundles != null && bundles.isEmpty()) {
            bundles = null;
        }
        return bundles;
    }

    public static interface Callback {
        public void handleNestedJar(BundleFile var1) throws IOException;

        public File handleJar(BundleFile var1) throws IOException;

        public File handleBundle(BundleFile var1) throws IOException;
    }
}

