/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;

public class FileWalker {
    public static final int CONTINUE = 0;
    public static final int RETURN = 1;
    public static final int BREAK = 2;

    public int walk(File root, Visitor visitor) {
        int ret = 0;
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                ret = visitor.visitDirectory(file);
                if (ret == 1) {
                    return 1;
                }
                if (ret == 2) {
                    return 0;
                }
                ret = this.walk(file, visitor);
                if (ret != 1) continue;
                return 1;
            }
            ret = visitor.visitFile(file);
            if (ret == 1) {
                return 1;
            }
            if (ret != 2) continue;
            return 0;
        }
        return 0;
    }

    public static abstract class Visitor {
        public int visitFile(File file) {
            return 0;
        }

        public int visitDirectory(File file) {
            return 0;
        }
    }
}

