/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.osgi;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.Notification;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.runtime.jboss.osgi.JBossBundleFile;
import org.nuxeo.runtime.jboss.osgi.JBossOSGiAdapterMBean;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class JBossOSGiAdapter
extends ListenerServiceMBeanSupport
implements JBossOSGiAdapterMBean {
    private static JBossOSGiAdapter instance;
    private OSGiAdapter osgi;

    public static JBossOSGiAdapter getInstance() {
        return instance;
    }

    public static DeploymentInfo getEARDeployment() {
        if (instance == null) {
            throw new IllegalStateException("JBossOSGiAdapter was not initialized");
        }
        try {
            return JBossOSGiAdapter.instance.getDeploymentInfo().parent;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public OSGiAdapter getOSGi() {
        return this.osgi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleImpl installBundle(String symbolicName, DeploymentInfo di) throws BundleException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)di.ucl);
        try {
            BundleImpl bundle;
            this.log.info((Object)("Installing OSGi bundle: " + di.url));
            if ("org.nuxeo.osgi".equals(symbolicName)) {
                bundle = new SystemBundle(this.osgi, new JBossBundleFile(di), (ClassLoader)di.ucl);
                this.osgi.setSystemBundle((SystemBundle)bundle);
                this.log.info((Object)("Installed system bundle: " + di.shortName));
            } else {
                bundle = new BundleImpl(this.osgi, new JBossBundleFile(di), (ClassLoader)di.ucl);
            }
            di.context.put("OSGI_BUNDLE", bundle);
            this.osgi.install(bundle);
            BundleImpl bundleImpl = bundle;
            return bundleImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void uninstallBundle(String symbolicName, DeploymentInfo di) throws BundleException {
        BundleImpl bundle = (BundleImpl)di.context.remove("OSGI_BUNDLE");
        if (bundle != null) {
            this.log.info((Object)("Uninstalling OSGi bundle: " + di.url));
            this.osgi.uninstall(bundle);
        }
    }

    protected void createService() throws Exception {
        super.createService();
        super.subscribe(true);
    }

    protected void startService() throws Exception {
        super.startService();
        instance = this;
        ServerConfig jbossConfig = ServerConfigLocator.locate();
        File workingDir = new File(jbossConfig.getServerDataDir(), "NXRuntime");
        File installDir = FileUtils.getFileFromURL((URL)JBossOSGiAdapter.getEARDeployment().url);
        File configDir = new File(installDir, "config");
        Environment env = new Environment(workingDir);
        env.setConfig(configDir);
        env.setLog(jbossConfig.getServerLogDir());
        env.setTemp(jbossConfig.getServerTempDir());
        env.setHostApplicationName("JBoss");
        Package pkg = Package.getPackage("org.jboss");
        if (pkg == null) {
            env.setHostApplicationVersion("4.0.5.GA");
        } else {
            env.setHostApplicationVersion(pkg.getImplementationVersion());
        }
        env.setIsApplicationServer(true);
        Environment.setDefault((Environment)env);
        this.osgi = new OSGiAdapter(workingDir);
        this.osgi.setProperty("INSTALL_DIR", installDir.getAbsolutePath());
        this.osgi.setProperty("CONFIG_DIR", configDir.getAbsolutePath());
        String addr = System.getProperty("jboss.bind.address");
        if (addr != null) {
            this.osgi.setProperty("nuxeo.bind.address", addr);
        }
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.osgi.shutdown();
        this.osgi = null;
    }

    protected void destroyService() throws Exception {
        super.unsubscribe();
        super.destroyService();
    }

    public String listBundles() {
        BundleImpl[] bundles = this.osgi.getInstalledBundles();
        Arrays.sort(bundles, new Comparator<BundleImpl>(){

            @Override
            public int compare(BundleImpl o1, BundleImpl o2) {
                return (int)(o1.getStartupTime() - o2.getStartupTime());
            }
        });
        StringBuilder buf = new StringBuilder();
        double total = 0.0;
        for (BundleImpl bundle : bundles) {
            buf.append(bundle.getBundleId()).append(": ").append(bundle.getSymbolicName()).append(" [ state: ").append(bundle.getState());
            double tm = bundle.getStartupTime();
            buf.append("; startup time: ").append(tm / 1000.0);
            total += tm;
            buf.append(" ]\n");
        }
        buf.append("\n------------------------------------------------------------\nDeployed ").append(bundles.length).append("  bundles in ").append(total / 1000.0).append(" sec.");
        return buf.toString();
    }

    public String getHomeLocation() {
        return this.osgi.getWorkingDir().getAbsolutePath();
    }

    public void handleNotification2(Notification notification, Object handback) {
        String type = notification.getType().intern();
        if (type == "org.jboss.system.server.started") {
            this.osgi.fireFrameworkEvent(new FrameworkEvent(1, this.osgi.getSystemBundle(), null));
            return;
        }
        try {
            String symbolicName;
            DeploymentInfo di = (DeploymentInfo)notification.getUserData();
            if (di == null || di.isXML || di.isScript || di.url.sameFile(this.getDeploymentInfo().url)) {
                return;
            }
            if (type == "org.jboss.deployment.SubDeployer.create") {
                Attributes mainAttributes;
                String val;
                Manifest mf = di.getManifest();
                if (mf != null && (val = (mainAttributes = mf.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
                    di.context.put("Bundle-SymbolicName", val);
                    val = mainAttributes.getValue("Bundle-ClassPath");
                    String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
                    if (val != null) {
                        classPath = classPath != null ? classPath + ',' + val : val;
                        mainAttributes.put(Attributes.Name.CLASS_PATH, classPath);
                    }
                }
            } else if (type == "org.jboss.deployment.SubDeployer.start") {
                String symbolicName2 = (String)di.context.get("Bundle-SymbolicName");
                if (symbolicName2 != null) {
                    this.installBundle(symbolicName2, di);
                }
            } else if (type == "org.jboss.deployment.SubDeployer.stop" && (symbolicName = (String)di.context.get("Bundle-SymbolicName")) != null) {
                this.uninstallBundle(symbolicName, di);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("NXRuntime deployment failed", e);
        }
    }
}

