/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.nuxeo.common.utils.FileNamePattern;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.NestedJarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.application.BundleWalker;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationLoader {
    protected final OSGiAdapter osgi;
    protected boolean extractNestedJARs = false;
    protected boolean scanForNestedJARs = false;
    private FileNamePattern[] patterns = BundleWalker.DEFAULT_PATTERNS;
    private final File tmpDir;

    protected ApplicationLoader(OSGiAdapter osgi) {
        this.osgi = osgi;
        this.tmpDir = new File(osgi.getDataDir(), "nested-bundles");
        this.tmpDir.mkdirs();
    }

    public abstract void installBundle(BundleFile var1) throws BundleException;

    public abstract void loadBundle(BundleFile var1);

    public abstract void loadJAR(BundleFile var1);

    public File getNestedBundleDirectory() {
        return this.tmpDir;
    }

    public void setExtractNestedJARs(boolean extractNestedJARs) {
        this.extractNestedJARs = extractNestedJARs;
    }

    public boolean getExtractNestedJARs() {
        return this.extractNestedJARs;
    }

    public void setScanForNestedJARs(boolean scanForNestedJARs) {
        this.scanForNestedJARs = scanForNestedJARs;
    }

    public boolean getScanForNestedJARs() {
        return this.scanForNestedJARs;
    }

    public void setPatterns(FileNamePattern[] patterns) {
        this.patterns = patterns;
    }

    public FileNamePattern[] getPatterns() {
        return this.patterns;
    }

    public void load(File root, List<BundleFile> bundles, List<BundleFile> jars) {
        BundleFileLoader callback = new BundleFileLoader(bundles, jars);
        BundleWalker visitor = new BundleWalker((BundleWalker.Callback)callback, this.patterns);
        visitor.visit(root);
    }

    public void installAll(Collection<BundleFile> bundleFiles) throws BundleException {
        for (BundleFile bundleFile : bundleFiles) {
            this.installBundle(bundleFile);
        }
    }

    public void install(File root) {
        BundleInstaller callback = new BundleInstaller();
        BundleWalker visitor = new BundleWalker((BundleWalker.Callback)callback, this.patterns);
        visitor.visit(root);
    }

    public void scan(File root, List<BundleFile> bundles, List<BundleFile> ljars) {
        BundleFileScanner callback = new BundleFileScanner(bundles, ljars);
        BundleWalker visitor = new BundleWalker((BundleWalker.Callback)callback, this.patterns);
        visitor.visit(root);
    }

    public abstract class DefaultCallback
    implements BundleWalker.Callback {
        public void visitBundle(BundleFile bundleFile) throws IOException {
            this.visitNestedBundles(bundleFile);
        }

        public void visitJar(BundleFile bundleFile) throws IOException {
            this.visitNestedBundles(bundleFile);
        }

        public void visitNestedBundles(BundleFile bundleFile) throws IOException {
            if (bundleFile instanceof NestedJarBundleFile) {
                return;
            }
            if (ApplicationLoader.this.extractNestedJARs) {
                Collection<BundleFile> bundles = ApplicationLoader.this.scanForNestedJARs ? bundleFile.findNestedBundles(ApplicationLoader.this.tmpDir) : bundleFile.getNestedBundles(ApplicationLoader.this.tmpDir);
                if (bundles == null || bundles.isEmpty()) {
                    return;
                }
                for (BundleFile bundle : bundles) {
                    if (bundle.getSymbolicName() != null) {
                        this.visitBundle(bundle);
                        continue;
                    }
                    this.visitJar(bundle);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BundleFileLoader
    extends DefaultCallback {
        final List<BundleFile> bundles;
        final List<BundleFile> jars;

        public BundleFileLoader(List<BundleFile> bundles, List<BundleFile> jars) {
            this.bundles = bundles;
            this.jars = jars;
        }

        @Override
        public void visitBundle(BundleFile bundleFile) throws IOException {
            ApplicationLoader.this.loadBundle(bundleFile);
            this.bundles.add(bundleFile);
            this.visitNestedBundles(bundleFile);
        }

        @Override
        public void visitJar(BundleFile bundleFile) throws IOException {
            ApplicationLoader.this.loadJAR(bundleFile);
            this.jars.add(bundleFile);
            this.visitNestedBundles(bundleFile);
        }

        public List<BundleFile> getBundles() {
            return this.bundles;
        }

        public List<BundleFile> getJARs() {
            return this.jars;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BundleFileScanner
    extends DefaultCallback {
        final List<BundleFile> bundles;
        final List<BundleFile> jars;

        public BundleFileScanner(List<BundleFile> bundles, List<BundleFile> jars) {
            this.bundles = bundles;
            this.jars = jars;
        }

        @Override
        public void visitBundle(BundleFile bundleFile) throws IOException {
            this.bundles.add(bundleFile);
            this.visitNestedBundles(bundleFile);
        }

        @Override
        public void visitJar(BundleFile bundleFile) throws IOException {
            this.jars.add(bundleFile);
            this.visitNestedBundles(bundleFile);
        }

        public List<BundleFile> getBundles() {
            return this.bundles;
        }

        public List<BundleFile> getJARs() {
            return this.jars;
        }
    }

    public class BundleInstaller
    extends DefaultCallback {
        public void visitBundle(BundleFile bundleFile) throws IOException {
            ApplicationLoader.this.loadBundle(bundleFile);
            this.visitNestedBundles(bundleFile);
        }

        public void visitJar(BundleFile bundleFile) throws IOException {
            ApplicationLoader.this.loadJAR(bundleFile);
            this.visitNestedBundles(bundleFile);
        }
    }
}

