/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.services;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;

public class ServiceReferenceImpl
implements ServiceReference {
    protected Bundle bundle;
    protected Object service;
    protected ServiceFactory factory;
    protected Map<String, Object> props;

    public ServiceReferenceImpl(Bundle bundle, Object service) {
        this.bundle = bundle;
        if (service instanceof ServiceFactory) {
            this.factory = (ServiceFactory)service;
        } else {
            this.service = service;
        }
    }

    public synchronized Object getProperty(String key) {
        return this.props != null ? this.props.get(key) : null;
    }

    public synchronized String[] getPropertyKeys() {
        return this.props != null ? this.props.keySet().toArray(new String[this.props.size()]) : null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Bundle[] getUsingBundles() {
        return new Bundle[0];
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        if (this.service == null) {
            return true;
        }
        try {
            return this.service.getClass() == bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public int compareTo(Object reference) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object getService() {
        return this.service == null ? this.factory.getService(this.bundle, null) : this.service;
    }

    public synchronized void setProperties(Dictionary<String, ?> dict) {
        if (this.props == null) {
            this.props = new HashMap<String, Object>();
        }
        Enumeration<String> en = dict.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            this.props.put(key, dict.get(key));
        }
    }
}

