/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.regex.Pattern;
import org.nuxeo.osgi.application.CommandLineOptions;
import org.nuxeo.osgi.application.SharedClassLoaderImpl;

public class TestMain {
    public static final String CONFIG_FILE = ".properties";
    public static final String BUNDLES = "bundles";
    public static final String INSTALL_DIR = "installdir";
    public static final String LIB_DIR = "libdir";
    public static final Pattern STR_LIST = Pattern.compile("\\s,\\s");

    public static void main(String[] args) throws Exception {
        String libList;
        String installDirProp;
        CommandLineOptions cmdArgs = new CommandLineOptions(args);
        String cfg = cmdArgs.getOption("f");
        File configFile = cfg != null ? new File(cfg) : new File(CONFIG_FILE);
        String bundlesList = null;
        if (configFile.isFile()) {
            Properties config = new Properties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(configFile));
            config.load(in);
            installDirProp = config.getProperty(INSTALL_DIR);
            bundlesList = config.getProperty(BUNDLES);
            libList = config.getProperty(LIB_DIR);
        } else {
            installDirProp = cmdArgs.getOption("d");
            bundlesList = cmdArgs.getOption("b");
            libList = cmdArgs.getOption("cp");
        }
        File installDir = null;
        installDir = installDirProp == null ? new File(".") : new File(installDirProp);
        SharedClassLoaderImpl cl = new SharedClassLoaderImpl(TestMain.class.getClassLoader());
        if (libList != null) {
            String[] stringArray = STR_LIST.split(libList, 0);
        }
    }
}

