/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.pubsub;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.pubsub.MemPubSubProvider;
import org.nuxeo.runtime.pubsub.PubSubProvider;
import org.nuxeo.runtime.pubsub.PubSubProviderDescriptor;
import org.nuxeo.runtime.pubsub.PubSubService;

public class PubSubServiceImpl
extends DefaultComponent
implements PubSubService {
    public static final String CONFIG_XP = "configuration";
    protected List<PubSubProviderDescriptor> providerDescriptors = new CopyOnWriteArrayList<PubSubProviderDescriptor>();
    protected PubSubProvider provider;
    protected PubSubProviderDescriptor providerDescriptor;
    protected Map<String, List<BiConsumer<String, byte[]>>> subscribers = new ConcurrentHashMap<String, List<BiConsumer<String, byte[]>>>();

    public void activate(ComponentContext context) {
        this.providerDescriptorChanged();
    }

    public void deactivate(ComponentContext context) {
        this.subscribers.clear();
        this.provider.close();
        this.provider = null;
    }

    public void start(ComponentContext context) {
        if (this.provider == null) {
            return;
        }
        this.provider.initialize(this.subscribers);
    }

    public void stop(ComponentContext context) {
        if (this.provider == null) {
            return;
        }
        this.provider.close();
    }

    public int getApplicationStartedOrder() {
        return -490;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!CONFIG_XP.equals(extensionPoint)) {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
        this.registerProvider((PubSubProviderDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_XP.equals(extensionPoint)) {
            this.unregisterProvider((PubSubProviderDescriptor)contribution);
        }
    }

    protected void registerProvider(PubSubProviderDescriptor descriptor) {
        this.providerDescriptors.add(descriptor);
        this.providerDescriptor = descriptor;
        this.providerDescriptorChanged();
    }

    protected void unregisterProvider(PubSubProviderDescriptor descriptor) {
        this.providerDescriptors.remove(descriptor);
        if (descriptor == this.providerDescriptor) {
            int size = this.providerDescriptors.size();
            this.providerDescriptor = size == 0 ? null : this.providerDescriptors.get(size - 1);
            this.providerDescriptorChanged();
        }
    }

    protected void providerDescriptorChanged() {
        if (this.provider != null) {
            this.provider.close();
        }
        this.provider = this.providerDescriptor == null ? new MemPubSubProvider() : this.providerDescriptor.getInstance();
    }

    @Override
    public void publish(String topic, byte[] message) {
        this.provider.publish(topic, message);
    }

    @Override
    public void registerSubscriber(String topic, BiConsumer<String, byte[]> subscriber) {
        this.subscribers.computeIfAbsent(topic, k -> new CopyOnWriteArrayList()).add(subscriber);
    }

    @Override
    public void unregisterSubscriber(String topic, BiConsumer<String, byte[]> subscriber) {
        this.subscribers.computeIfAbsent(topic, k -> new CopyOnWriteArrayList()).remove(subscriber);
    }
}

