/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config.v1;

import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.config.AbstractServerConfiguration;
import org.nuxeo.runtime.services.streaming.StreamingService;

public class ServerConfiguration1
extends AbstractServerConfiguration {
    private static final long serialVersionUID = 1970555604877434479L;
    private ServiceDescriptor[] serviceDescriptors;
    private ServiceHost[] hosts;

    public ServerConfiguration1(InvokerLocator locator, String name, Version version) {
        super(locator, name, version);
    }

    public ServiceDescriptor[] getServiceBindingsCompat() {
        return this.serviceDescriptors;
    }

    public void setServiceBindingsCompat(ServiceDescriptor[] bindings) {
        this.serviceDescriptors = bindings;
    }

    public ServiceHost[] getServiceHostsCompat() {
        return this.hosts;
    }

    public void setServiceHostsCompat(ServiceHost[] hosts) {
        this.hosts = hosts;
    }

    @Override
    public void install() throws Exception {
        ServiceManager serviceMgr = (ServiceManager)Framework.getLocalService(ServiceManager.class);
        LoginService loginMgr = (LoginService)Framework.getLocalService(LoginService.class);
        if (this.streamingLocator != null) {
            this.loadStreamingConfig(this.streamingLocator);
        }
        for (ServiceHost serviceHost : this.hosts) {
            serviceMgr.registerServer(serviceHost);
        }
        for (ServiceHost serviceHost : this.serviceDescriptors) {
            serviceMgr.registerService((ServiceDescriptor)serviceHost);
        }
        for (ServiceHost serviceHost : this.securityDomains) {
            loginMgr.addSecurityDomain((SecurityDomain)serviceHost);
        }
    }

    protected void loadStreamingConfig(String serverLocator) throws Exception {
        String oldLocator;
        StreamingService streamingService = (StreamingService)((Object)Framework.getRuntime().getComponent(StreamingService.NAME));
        if (!streamingService.isServer() && !serverLocator.equals(oldLocator = streamingService.getServerLocator())) {
            streamingService.stopManager();
            streamingService.setServerLocator(serverLocator);
            streamingService.setServer(false);
            streamingService.startManager();
        }
    }
}

