/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.loading.ClassUtil;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.config.ConfigurationException;
import org.nuxeo.runtime.config.ConfigurationFactory;
import org.nuxeo.runtime.config.ServerConfiguration;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.Server;

public class ServerImpl
implements Server {
    private static final Log log = LogFactory.getLog(ServerImpl.class);
    private final RuntimeService runtime;
    private final RemotingService remoting;

    public ServerImpl(RemotingService service, RuntimeService runtime) {
        this.remoting = service;
        this.runtime = runtime;
    }

    @Override
    public String getName() {
        String name = Framework.getRuntime().getProperty("org.nuxeo.ecm.instance.name");
        if (name == null) {
            name = "Nuxeo Runtime Server";
        }
        return name;
    }

    @Override
    public String getProductInfo() {
        String name = Framework.getRuntime().getProperty("org.nuxeo.ecm.product.name");
        String version = Framework.getRuntime().getProperty("org.nuxeo.ecm.product.version");
        if (name == null) {
            name = "Nuxeo Runtime Server";
            version = this.runtime.getVersion().toString();
        } else if (version == null) {
            version = "0.0.0";
        }
        return name + ' ' + version;
    }

    @Override
    public String[] getServiceBindings() {
        ServiceManager sm = (ServiceManager)Framework.getLocalService(ServiceManager.class);
        ServiceDescriptor[] services = sm.getServiceDescriptors();
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceDescriptor sd : services) {
            result.add(sd.getGroup().getName());
            result.add(sd.getServiceClassName());
            result.add(sd.getName());
            result.add(sd.getLocator());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Properties[] getServiceHosts() throws Exception {
        ServiceManager sm = (ServiceManager)Framework.getLocalService(ServiceManager.class);
        ServiceHost[] servers = sm.getServers();
        ArrayList<Properties> result = new ArrayList<Properties>(servers.length);
        for (ServiceHost server : servers) {
            ServiceGroup[] groups;
            String host;
            Properties value = server.getProperties();
            if (value == null) {
                value = new Properties();
            }
            if ((host = server.getHost()) != null) {
                value.put("@host", host);
                value.put("@port", (Object)server.getPort());
            }
            if ((groups = server.getGroups()).length > 0) {
                String[] names = new String[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    names[i] = groups[i].getName();
                }
                value.put("@groups", names);
            }
            value.put("@class", server.getServiceLocator().getClass().getName());
            result.add(value);
        }
        return result.toArray(new Properties[result.size()]);
    }

    @Override
    public Map<String, Object[][]> getSecurityDomains() throws Exception {
        LoginService loginService = (LoginService)Framework.getLocalService(LoginService.class);
        HashMap<String, Object[][]> result = new HashMap<String, Object[][]>();
        for (SecurityDomain domain : loginService.getSecurityDomains()) {
            AppConfigurationEntry[] entries = domain.getAppConfigurationEntries();
            if (entries == null || entries.length <= 0) continue;
            String key = domain.getName();
            Object[][] value = new Object[entries.length][3];
            for (int i = 0; i < entries.length; ++i) {
                value[i][0] = entries[i].getLoginModuleName();
                value[i][1] = SecurityDomain.controlFlagToString((AppConfigurationEntry.LoginModuleControlFlag)entries[i].getControlFlag());
                value[i][2] = entries[i].getOptions();
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        Properties rtProps = Framework.getRuntime().getProperties();
        for (Map.Entry<Object, Object> entry : rtProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = Framework.expandVars((String)entry.getValue().toString());
            props.put(key, value);
        }
        return props;
    }

    @Override
    public ComponentName[] getComponents() {
        Collection regs = Framework.getRuntime().getComponentManager().getRegistrations();
        ArrayList<ComponentName> comps = new ArrayList<ComponentName>();
        for (RegistrationInfo ri : regs) {
            comps.add(ri.getName());
        }
        return comps.toArray(new ComponentName[comps.size()]);
    }

    @Override
    public boolean hasComponent(ComponentName name) {
        return false;
    }

    @Override
    public Collection<ComponentInstance> getActiveComponents() {
        return null;
    }

    @Override
    public ComponentInstance getComponent(String name) {
        return null;
    }

    @Override
    public ComponentInstance getComponent(ComponentName name) {
        return null;
    }

    @Override
    public String getDescription() {
        return this.runtime.getDescription();
    }

    @Override
    public Collection<RegistrationInfo> getRegistrations() {
        return this.runtime.getComponentManager().getRegistrations();
    }

    @Override
    public String getServerAddress() {
        return null;
    }

    @Override
    public ServerConfiguration getConfiguration(InvokerLocator locator, Version version) throws ConfigurationException {
        ConfigurationFactory factory = ConfigurationFactory.getFactory(version);
        return factory.createConfiguration(locator, version);
    }

    public void contributeExtension(Extension extension, String xmlContent) throws Exception {
    }

    @Override
    public byte[] getLocalResource(ComponentName component, String name) {
        return this.getResource(component, name);
    }

    @Override
    public byte[] getResource(ComponentName component, String name) {
        log.info((Object)("Loading resource: " + name + " using " + component + " context"));
        ComponentInstance ci = Framework.getRuntime().getComponentInstance(component);
        if (ci == null) {
            return null;
        }
        URL url = ci.getContext().getResource(name);
        if (url != null) {
            try {
                return FileUtils.readBytes((URL)url);
            }
            catch (IOException e) {
                log.error((Object)("Failed to load resource: " + name), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public byte[] getClass(ComponentName component, String name) {
        log.info((Object)("Loading class: " + name + " using " + component + " context"));
        ComponentInstance ci = Framework.getRuntime().getComponentInstance(component);
        if (ci == null) {
            return null;
        }
        String resourceName = ServerImpl.getClassResource(name);
        URL classUrl = ci.getContext().getResource(resourceName);
        if (classUrl != null) {
            try {
                return FileUtils.readBytes((URL)classUrl);
            }
            catch (IOException e) {
                log.error((Object)("Failed to load class " + name), (Throwable)e);
            }
        }
        return null;
    }

    private static String getClassResource(String className) {
        String cn = ClassUtil.isArrayClass((String)className) ? ClassUtil.getArrayClassPart((String)className).replace('.', '/') + ".class" : className.replace('.', '/') + ".class";
        return cn;
    }
}

