/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.remoting.RemoteComponent;
import org.nuxeo.runtime.remoting.Server;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;

@XObject(value="server")
public class ServerDescriptor {
    private final InvokerLocator locator;
    private Server server;
    private Map<ComponentName, RemoteComponent> components;
    private Set<String> extensions;

    public ServerDescriptor(InvokerLocator locator) {
        this.locator = locator;
        this.components = new Hashtable<ComponentName, RemoteComponent>();
        this.extensions = new HashSet<String>();
    }

    public ServerDescriptor(String uri) throws MalformedURLException {
        this(new InvokerLocator(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server getServer() throws Exception {
        if (this.server == null) {
            ServerDescriptor serverDescriptor = this;
            synchronized (serverDescriptor) {
                if (this.server == null) {
                    this.server = (Server)TransporterClient.createTransporterClient(this.locator, Server.class);
                }
            }
        }
        return this.server;
    }

    public String getURI() {
        return this.locator.getLocatorURI();
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public Collection<ComponentName> getComponents() {
        return this.components.keySet();
    }

    public RemoteComponent addComponent(ComponentName name) {
        RemoteComponent rco = new RemoteComponent(this, name);
        this.components.put(name, rco);
        return rco;
    }

    public RemoteComponent getComponent(ComponentName name) {
        return this.components.get(name);
    }

    public RemoteComponent removeComponent(ComponentName name) {
        return this.components.remove(name);
    }

    public boolean hasComponent(ComponentName name) {
        return this.components.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addExtension(String extensionId) {
        if (!this.extensions.contains(extensionId)) {
            ServerDescriptor serverDescriptor = this;
            synchronized (serverDescriptor) {
                if (!this.extensions.contains(extensionId)) {
                    this.extensions.add(extensionId);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String extensionId) {
        ServerDescriptor serverDescriptor = this;
        synchronized (serverDescriptor) {
            return this.extensions.contains(extensionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeExtension(String extensionId) {
        ServerDescriptor serverDescriptor = this;
        synchronized (serverDescriptor) {
            return this.extensions.remove(extensionId);
        }
    }

    public void destroy() {
        if (this.server != null) {
            TransporterClient.destroyTransporterClient(this.server);
            this.server = null;
        }
        this.components.clear();
        this.components = null;
        this.extensions.clear();
        this.extensions = null;
    }
}

