/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.config.ConfigurationHelper;
import org.nuxeo.runtime.remoting.RemotingService;

public class NodeConfiguration
implements Serializable,
Cloneable {
    public static final String NODE_ID = "org.nuxeo.runtime.nodeId";
    public static final String SERVER_ENABLED = "org.nuxeo.runtime.server.enabled";
    public static final String SERVER_TYPE = "org.nuxeo.runtime.server.type";
    public static final String SERVER_LOCATOR = "org.nuxeo.runtime.server.locator";
    public static final String SERVER_HOST = "org.nuxeo.runtime.server.host";
    public static final String SERVER_PORT = "org.nuxeo.runtime.server.port";
    public static final String PEERS = "org.nuxeo.runtime.peers";
    public static final String AUTODETECT_PEERS = "org.nuxeo.runtime.peers.autodetect";
    public static final String CLIENT_JNDI_PREFIX = "nuxeo-client-jndi.";
    public static final String PRODUCT_NAME = "org.nuxeo.ecm.product.name";
    public static final String PRODUCT_VERSION = "org.nuxeo.ecm.product.version";
    public static final String IS_STREAMING_SERVER = "org.nuxeo.runtime.streaming.isServer";
    public static final String STREAMING_LOCATOR = "org.nuxeo.runtime.streaming.serverLocator";
    private static NodeConfiguration configuration;
    private static final long serialVersionUID = 1227680972931266947L;
    private final String nodeId = Framework.getProperty((String)"org.nuxeo.runtime.nodeId", (String)"local");
    private final String serverType;
    private InvokerLocator locator;
    private boolean isServer = Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.runtime.server.enabled", (String)"false"));
    private Properties env;
    private final String productName;
    private final String productVersion;
    private String streamingLocator;
    private boolean isStreamingServer;
    private boolean isAutoDetectingPeers = false;

    public static NodeConfiguration getConfiguration() {
        if (configuration == null) {
            try {
                configuration = new NodeConfiguration();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to initialize Node Configuration", e);
            }
        }
        return configuration;
    }

    public static void setConfiguration(NodeConfiguration cfg) {
        configuration = cfg;
    }

    public NodeConfiguration() throws MalformedURLException {
        this.serverType = Framework.getProperty((String)SERVER_TYPE);
        String uri = Framework.getProperty((String)SERVER_LOCATOR);
        if (uri == null) {
            String host = Framework.getProperty((String)SERVER_HOST, (String)"localhost");
            int port = Integer.parseInt(Framework.getProperty((String)SERVER_PORT, (String)"62474"));
            uri = "socket://" + host + ":" + port + "/?datatype=nuxeo";
        }
        this.locator = new InvokerLocator(uri);
        this.productName = Framework.getProperty((String)PRODUCT_NAME);
        this.productVersion = Framework.getProperty((String)PRODUCT_VERSION);
        this.isStreamingServer = Boolean.parseBoolean(Framework.getProperty((String)IS_STREAMING_SERVER, (String)"false"));
        this.streamingLocator = this.isStreamingServer ? ((RemotingService)((Object)Framework.getLocalService(RemotingService.class))).getServerLocator().getLocatorURI() : Framework.getProperty((String)STREAMING_LOCATOR);
        this.isAutoDetectingPeers = Boolean.parseBoolean(Framework.getProperty((String)AUTODETECT_PEERS, (String)"false"));
        this.env = new Properties();
        int len = CLIENT_JNDI_PREFIX.length();
        for (Map.Entry<Object, Object> entry : Framework.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(CLIENT_JNDI_PREFIX)) continue;
            this.env.put(key.substring(len), entry.getValue());
        }
        if (this.env.isEmpty()) {
            this.env = null;
        }
    }

    public boolean isServerNode() {
        return System.getProperty("jboss.home.dir") != null;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public String getServerType() {
        return this.serverType;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public String getHost() {
        return this.locator.getHost();
    }

    public int getPort() {
        return this.locator.getPort();
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getStreamingLocator() {
        return this.streamingLocator;
    }

    public boolean isStreamingServer() {
        return this.isStreamingServer;
    }

    public boolean isAutoDetectingPeers() {
        return this.isAutoDetectingPeers;
    }

    public Properties getClientEnvironment() {
        return this.env;
    }

    public void normalize(InvokerLocator locator) throws MalformedURLException {
        String value;
        String host;
        if (this.isServer && !locator.equals((Object)this.locator) && !(host = ConfigurationHelper.getNormalizedHost(this.locator.getHost(), locator.getHost())).equals(this.locator.getHost())) {
            this.locator = new InvokerLocator(ConfigurationHelper.getNormalizedURI(this.locator.getLocatorURI(), locator.getHost()));
        }
        if (this.isStreamingServer) {
            this.streamingLocator = locator.getLocatorURI();
        } else if (this.streamingLocator != null) {
            this.streamingLocator = ConfigurationHelper.getNormalizedURI(this.streamingLocator, locator.getHost());
        }
        if (this.env != null && (value = this.env.getProperty("java.naming.provider.url")) != null) {
            value = String.format(value, locator.getHost());
            this.env.put("java.naming.provider.url", value);
        }
    }

    public NodeConfiguration clone() throws CloneNotSupportedException {
        NodeConfiguration clone = (NodeConfiguration)super.clone();
        clone.env = new Properties();
        clone.env.putAll((Map<?, ?>)this.env);
        return clone;
    }
}

