/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;
import org.nuxeo.runtime.scripting.RemoteScript;
import org.nuxeo.runtime.scripting.ScriptingServer;

public class ScriptingClient {
    private ScriptingServer server;
    private ScriptContext ctx = new SimpleScriptContext();

    public ScriptingClient(String host, int port) throws Exception {
        String serverLocator = RemotingService.getServerURI((String)host, (int)port);
        this.server = (ScriptingServer)TransporterClient.createTransporterClient((InvokerLocator)new InvokerLocator(serverLocator), ScriptingServer.class);
    }

    public ScriptingServer getServer() {
        return this.server;
    }

    public RemoteScript loadScript(File file) throws IOException {
        return this.loadScript(file.getAbsolutePath(), new FileReader(file));
    }

    public RemoteScript loadScript(URL url) throws IOException {
        return this.loadScript(url.toExternalForm(), new InputStreamReader(url.openStream()));
    }

    public RemoteScript loadScript(String name, String content) {
        return new RemoteScript(this, name, content);
    }

    public RemoteScript loadScript(String name, Reader reader) throws IOException {
        return new RemoteScript(this, name, ScriptingClient.readScriptContent(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readScriptContent(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[32768];
            while ((read = reader.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, read));
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    public void setScriptContext(ScriptContext ctx) {
        this.ctx = ctx;
    }

    public ScriptContext getScriptContext() {
        return this.ctx;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java -cp ... org.nuxeo.runtime.scripting.ScriptingClient localhost:62474 test.js");
            System.exit(1);
        }
        String[] addr = args[0].split(":");
        String host = addr[0];
        int port = 62474;
        if (addr.length == 2) {
            try {
                port = Integer.parseInt(addr[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid port number: " + addr[1]);
                System.exit(2);
            }
        }
        try {
            ScriptingClient client = new ScriptingClient(host, port);
            RemoteScript script = client.loadScript(new File(args[1]));
            script.eval();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

