/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.scripting;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.transporter.TransporterServer;
import org.nuxeo.runtime.scripting.ScriptDescriptor;
import org.nuxeo.runtime.scripting.ScriptingServer;
import org.nuxeo.runtime.scripting.ScriptingServerImpl;
import org.nuxeo.runtime.scripting.ScriptingService;

public class ScriptingComponent
extends DefaultComponent
implements ScriptingService {
    private static final Log log = LogFactory.getLog(ScriptingService.class);
    private ScriptEngineManager scriptMgr;
    private Map<String, ScriptDescriptor> scripts;
    private File scriptDir;
    private ScriptingServer server;

    public void activate(ComponentContext context) throws Exception {
        RuntimeService runtime = Framework.getRuntime();
        String scrPath = Framework.getRuntime().getProperty("org.nuxeo.scripts.dir");
        this.scriptDir = scrPath == null ? new File(runtime.getHome(), "scripts") : new File(scrPath);
        this.scripts = new Hashtable<String, ScriptDescriptor>();
        this.scriptMgr = new ScriptEngineManager();
        Boolean isServer = (Boolean)context.getPropertyValue("isServer", (Object)Boolean.TRUE);
        if (isServer.booleanValue()) {
            this.server = new ScriptingServerImpl(this);
            RemotingService remoting = (RemotingService)Framework.getRuntime().getComponent(RemotingService.NAME);
            TransporterServer transporterServer = remoting.getTransporterServer();
            transporterServer.addHandler((Object)this.server, ScriptingServer.class.getName());
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.server = null;
        this.scriptMgr = null;
        this.scripts = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ScriptDescriptor sd = (ScriptDescriptor)contribution;
        sd.ctx = contributor.getRuntimeContext();
        this.registerScript(sd);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ScriptDescriptor sd = (ScriptDescriptor)contribution;
        this.unregisterScript(sd);
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptMgr;
    }

    public void setScriptDir(File scriptDir) {
        this.scriptDir = scriptDir;
    }

    public File getScriptDir() {
        return this.scriptDir;
    }

    public File getScriptFile(String path) {
        return new File(this.scriptDir, path);
    }

    public void registerScript(ScriptDescriptor sd) {
        if (sd.name == null) {
            sd.name = sd.src;
        }
        this.scripts.put(sd.name, sd);
    }

    public void unregisterScript(ScriptDescriptor sd) {
        if (sd.name == null) {
            sd.name = sd.src;
        }
        this.scripts.remove(sd.name);
    }

    public void unregisterScript(String name) {
        this.scripts.remove(name);
    }

    public boolean isScriptRegistered(String name) {
        return this.scripts.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript getScript(String name) throws ScriptException, IOException {
        ScriptDescriptor sd = this.scripts.get(name);
        if (sd != null) {
            if (sd.script != null) {
                return sd.script;
            }
            ScriptEngine engine = this.getEngineByFileName(sd.src);
            if (engine == null) {
                log.warn((Object)("Script engine not found for: " + sd.src));
            } else {
                if (engine instanceof Compilable) {
                    CompiledScript compiledScript;
                    Reader reader = this.getReader(sd);
                    try {
                        compiledScript = sd.script = ((Compilable)((Object)engine)).compile(reader);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (ScriptException e) {
                            throw new ScriptException("Script file was not found: " + sd.src + " when trying to load " + name);
                        }
                    }
                    reader.close();
                    return compiledScript;
                }
                throw new ScriptException("Not a compilable scripting engine: " + engine.getFactory().getEngineName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript compile(String path) throws ScriptException {
        ScriptEngine engine = this.getEngineByFileName(path);
        if (engine != null) {
            if (engine instanceof Compilable) {
                CompiledScript compiledScript;
                FileReader reader = new FileReader(this.getScriptFile(path));
                try {
                    compiledScript = ((Compilable)((Object)engine)).compile(reader);
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)reader).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ScriptException(e);
                    }
                }
                ((Reader)reader).close();
                return compiledScript;
            }
            throw new ScriptException("Script Engine " + engine.getFactory().getEngineName() + " is not compilable");
        }
        throw new ScriptException("No suitable script engine found for the file " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String path) throws ScriptException {
        ScriptEngine engine = this.getEngineByFileName(path);
        if (engine != null) {
            Object object;
            FileReader reader = new FileReader(this.getScriptFile(path));
            try {
                object = engine.eval(reader);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return object;
        }
        throw new ScriptException("No script engine was found for the file: " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String path, ScriptContext ctx) throws ScriptException {
        ScriptEngine engine = this.getEngineByFileName(path);
        if (engine != null) {
            Object object;
            FileReader reader = new FileReader(this.getScriptFile(path));
            try {
                object = engine.eval((Reader)reader, ctx);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return object;
        }
        throw new ScriptException("No script engine was found for the file: " + path);
    }

    public ScriptEngine getEngineByFileName(String path) {
        String ext = ScriptingComponent.getFileExtension(path);
        return ext == null ? null : this.scriptMgr.getEngineByExtension(ext);
    }

    public static String getFileExtension(String path) {
        int p = path.lastIndexOf(46);
        if (p > -1) {
            return path.substring(p + 1);
        }
        return null;
    }

    private Reader getReader(ScriptDescriptor sd) throws IOException {
        InputStreamReader reader;
        if (sd.ctx == null) {
            File file = new File(this.scriptDir, sd.src);
            reader = new FileReader(file);
        } else {
            URL url = sd.ctx.getLocalResource(sd.src);
            if (url != null) {
                reader = new InputStreamReader(url.openStream());
            } else {
                throw new FileNotFoundException(sd.src);
            }
        }
        return reader;
    }
}

