/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.scripting;

import java.io.Writer;
import java.util.HashMap;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.nuxeo.runtime.scripting.ScriptingClient;

public class RemoteScript {
    private final ScriptingClient client;
    private final String name;
    private final String content;
    private ScriptContext ctx;

    RemoteScript(ScriptingClient client, String name, String content) {
        this.client = client;
        this.content = content;
        this.name = name;
        this.ctx = client.getScriptContext();
    }

    public Object eval() throws ScriptException {
        Object[] response;
        HashMap<String, Object> context = null;
        Writer out = null;
        if (this.ctx != null) {
            context = new HashMap<String, Object>(this.ctx.getBindings(100));
            out = this.ctx.getWriter();
        }
        try {
            response = this.client.getServer().eval(this.name, this.content, context);
            String output = (String)response[0];
            if (out != null) {
                out.write(output);
                out.flush();
            } else {
                System.out.println(output);
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return response[1];
    }

    public Object invoke(String method, Object ... args) throws ScriptException {
        Object[] response;
        HashMap<String, Object> context = null;
        Writer out = null;
        if (this.ctx != null) {
            context = new HashMap<String, Object>(this.ctx.getBindings(100));
            out = this.ctx.getWriter();
        }
        try {
            response = this.client.getServer().invoke(this.name, this.content, context, method, args);
            String output = (String)response[0];
            if (out != null) {
                out.write(output);
                out.flush();
            } else {
                System.out.println(output);
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return response[1];
    }

    public ScriptingClient getClient() {
        return this.client;
    }

    public void setContext(ScriptContext ctx) {
        this.ctx = ctx;
    }

    public ScriptContext getContext() {
        return this.ctx;
    }
}

