/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@Deploys(value={@Deploy(value={"org.nuxeo.runtime.stream"}), @Deploy(value={"org.nuxeo.runtime.stream.test"})})
@Features(value={RuntimeFeature.class})
public class RuntimeStreamFeature
implements RunnerFeature {
    private static final Log log = LogFactory.getLog(RuntimeStreamFeature.class);
    public static final String BUNDLE_TEST_NAME = "org.nuxeo.runtime.stream.test";
    public static final String STREAM_PROPERTY = "nuxeo.test.stream";
    public static final String STREAM_CHRONICLE = "chronicle";
    public static final String STREAM_KAFKA = "kafka";
    public static final String KAFKA_SERVERS_PROPERTY = "nuxeo.test.kafka.servers";
    public static final String KAFKA_SERVERS_DEFAULT = "localhost:9092";
    protected String streamType;

    protected static String defaultProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.isEmpty() || value.equals("${" + name + "}")) {
            value = def;
        }
        Framework.getProperties().setProperty(name, value);
        return value;
    }

    public void start(FeaturesRunner runner) {
        RuntimeHarness harness = ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness();
        this.streamType = RuntimeStreamFeature.defaultProperty(STREAM_PROPERTY, STREAM_CHRONICLE);
        try {
            String msg = "Deploying Nuxeo Stream using " + StringUtils.capitalize((String)this.streamType.toLowerCase());
            System.out.println(this.getClass().getSimpleName() + ": " + msg);
            log.info((Object)msg);
            switch (this.streamType) {
                case "chronicle": {
                    break;
                }
                case "kafka": {
                    this.initKafka(harness);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.streamType + " stream type is not supported");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeServiceException("Unable to configure the stream implementation", (Throwable)e);
        }
    }

    protected void initKafka(RuntimeHarness harness) throws Exception {
        RuntimeStreamFeature.defaultProperty(KAFKA_SERVERS_PROPERTY, KAFKA_SERVERS_DEFAULT);
        harness.deployContrib(BUNDLE_TEST_NAME, "OSGI-INF/test-stream-kafka-contrib.xml");
    }
}

