/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.message.SchemaStore;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.avro.AvroService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.runtime.stream"}), @Deploy(value={"org.nuxeo.runtime.stream:test-avro-contrib.xml"})})
public class TestAvroSchemaStore {
    @Inject
    public AvroService service;

    @Test
    public void testSchemaRetrieval() throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("data/avro-schema-example.json");){
            Schema schema = new Schema.Parser().parse(stream);
            long fingerprint = SchemaNormalization.parsingFingerprint64((Schema)schema);
            Schema retrieved = this.service.findByFingerprint(fingerprint);
            Assert.assertEquals((Object)schema, (Object)retrieved);
        }
    }

    @Test
    public void testSchemaStoreRetrieval() {
        Assert.assertNotNull((Object)Framework.getService(SchemaStore.class));
    }
}

