/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.MockObjectTestCase;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.application.StandaloneBundleLoader;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.nuxeo.runtime.test.RootRuntimeBundle;
import org.nuxeo.runtime.test.TestRuntime;
import org.osgi.framework.Bundle;

public class NXRuntimeTestCase
extends MockObjectTestCase {
    private static final Log log = LogFactory.getLog(NXRuntimeTestCase.class);
    protected RuntimeService runtime;
    protected URL[] urls;
    protected File workingDir;
    private static int counter = 0;
    protected StandaloneBundleLoader bundleLoader;
    private Set<URI> readUris;
    protected Map<String, BundleFile> bundles;
    protected boolean restart = false;

    public NXRuntimeTestCase() {
    }

    public NXRuntimeTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restart() throws Exception {
        this.restart = true;
        try {
            this.tearDown();
            this.setUp();
        }
        finally {
            this.restart = false;
        }
    }

    public void setUp() throws Exception {
        System.setProperty("org.nuxeo.runtime.testing", "true");
        super.setUp();
        this.wipeRuntime();
        this.initUrls();
        if (this.urls == null) {
            this.initTestRuntime();
        } else {
            this.initOsgiRuntime();
        }
    }

    public void tearDown() throws Exception {
        this.wipeRuntime();
        if (this.workingDir != null && !this.restart) {
            FileUtils.deleteTree((File)this.workingDir);
            this.workingDir = null;
        }
        this.readUris = null;
        this.bundles = null;
        super.tearDown();
    }

    private static synchronized String generateId() {
        long stamp = System.currentTimeMillis();
        return Long.toHexString(stamp) + '-' + System.identityHashCode(System.class) + '.' + ++counter;
    }

    protected void initOsgiRuntime() throws Exception {
        try {
            if (!this.restart) {
                this.workingDir = File.createTempFile("NXOSGITestFramework", NXRuntimeTestCase.generateId());
                this.workingDir.delete();
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not init working directory", (Throwable)e);
            throw e;
        }
        OSGiAdapter osgi = new OSGiAdapter(this.workingDir);
        this.bundleLoader = new StandaloneBundleLoader(osgi, NXRuntimeTestCase.class.getClassLoader());
        Thread.currentThread().setContextClassLoader((ClassLoader)this.bundleLoader.getSharedClassLoader());
        this.bundleLoader.setScanForNestedJARs(false);
        this.bundleLoader.setExtractNestedJARs(false);
        BundleFile bundleFile = this.lookupBundle("org.nuxeo.runtime");
        RootRuntimeBundle bundle = new RootRuntimeBundle(osgi, bundleFile, this.bundleLoader.getClass().getClassLoader(), true);
        bundle.start();
        this.runtime = Framework.getRuntime();
        NXRuntimeTestCase.assertNotNull((Object)this.runtime);
        this.deployContrib(bundleFile, "OSGI-INF/DeploymentService.xml");
        this.deployContrib(bundleFile, "OSGI-INF/LoginComponent.xml");
        this.deployContrib(bundleFile, "OSGI-INF/ServiceManagement.xml");
        this.deployContrib(bundleFile, "OSGI-INF/EventService.xml");
        this.deployContrib(bundleFile, "OSGI-INF/DefaultJBossBindings.xml");
    }

    protected void initTestRuntime() throws Exception {
        this.runtime = new TestRuntime();
        Framework.initialize((RuntimeService)this.runtime);
        this.deployContrib("org.nuxeo.runtime.test", "EventService.xml");
        this.deployContrib("org.nuxeo.runtime.test", "DeploymentService.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initUrls() {
        block10: {
            ClassLoader classLoader = NXRuntimeTestCase.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                log.warn((Object)("Unknow classloader type: " + classLoader.getClass().getName() + "\nWon't be able to load OSGI bundles"));
                return;
            }
            this.urls = ((URLClassLoader)classLoader).getURLs();
            if (this.urls.length == 1) {
                try {
                    URI uri = this.urls[0].toURI();
                    if (!uri.getScheme().equals("file") || !uri.getPath().contains("surefirebooter")) break block10;
                    JarFile jar = new JarFile(new File(uri));
                    try {
                        String cp = jar.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if (cp != null) {
                            String[] cpe = cp.split(" ");
                            URL[] newUrls = new URL[cpe.length];
                            for (int i = 0; i < cpe.length; ++i) {
                                String newUrl = cpe[i].startsWith("file:") ? cpe[i] : "file:" + cpe[i];
                                newUrls[i] = new URL(newUrl);
                            }
                            this.urls = newUrls;
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("URLs on the classpath: ");
        for (URL url : this.urls) {
            sb.append(url.toString());
            sb.append('\n');
        }
        log.debug((Object)sb.toString());
        this.readUris = new HashSet<URI>();
        this.bundles = new HashMap<String, BundleFile>();
    }

    protected void wipeRuntime() throws Exception {
        this.runtime = null;
        if (Framework.getRuntime() != null) {
            Framework.shutdown();
        }
    }

    public static URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    @Deprecated
    public void deploy(String contrib) {
        this.deployContrib(contrib);
    }

    protected void deployContrib(URL url) {
        NXRuntimeTestCase.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        log.info((Object)("Deploying contribution from " + url.toString()));
        try {
            this.runtime.getContext().deploy(url);
        }
        catch (Exception e) {
            log.error((Object)e);
            NXRuntimeTestCase.fail((String)("Failed to deploy contrib " + url.toString()));
        }
    }

    @Deprecated
    public void deployContrib(String contrib) {
        URL url = NXRuntimeTestCase.getResource(contrib);
        NXRuntimeTestCase.assertNotNull((String)("Test contribution not found: " + contrib), (Object)url);
        this.deployContrib(url);
    }

    protected void deployContrib(BundleFile bundleFile, String contrib) {
        URL url = bundleFile.getEntry(contrib);
        if (url == null) {
            NXRuntimeTestCase.fail((String)String.format("Could not find entry %s in bundle '%s", contrib, bundleFile.getURL()));
        }
        this.deployContrib(url);
    }

    public void deployContrib(String bundle, String contrib) throws Exception {
        this.deployContrib(this.lookupBundle(bundle), contrib);
    }

    public RuntimeContext deployTestContrib(String bundle, String contrib) throws Exception {
        BundleImpl b = this.bundleLoader.getOSGi().getRegistry().getBundle(bundle);
        if (b != null) {
            OSGiRuntimeContext ctx = new OSGiRuntimeContext(this.runtime, (Bundle)b);
            ctx.deploy(contrib);
            return ctx;
        }
        throw new IllegalArgumentException("Bundle not deployed " + bundle);
    }

    public RuntimeContext deployTestContrib(String bundle, URL contrib) throws Exception {
        BundleImpl b = this.bundleLoader.getOSGi().getRegistry().getBundle(bundle);
        if (b != null) {
            OSGiRuntimeContext ctx = new OSGiRuntimeContext(this.runtime, (Bundle)b);
            ctx.deploy(contrib);
            return ctx;
        }
        throw new IllegalArgumentException("Bundle not deployed " + bundle);
    }

    @Deprecated
    public void undeploy(String contrib) {
        this.undeployContrib(contrib);
    }

    @Deprecated
    public void undeployContrib(String contrib) {
        URL url = NXRuntimeTestCase.getResource(contrib);
        NXRuntimeTestCase.assertNotNull((String)("Test contribution not found: " + contrib), (Object)url);
        this.deployContrib(url);
    }

    public void undeployContrib(String bundle, String contrib) throws Exception {
        BundleFile b = this.lookupBundle(bundle);
        URL url = b.getEntry(contrib);
        if (url == null) {
            NXRuntimeTestCase.fail((String)String.format("Could not find entry %s in bundle '%s'", contrib, b.getURL()));
        }
        this.runtime.getContext().undeploy(url);
    }

    @Deprecated
    protected void undeployContrib(URL url, String contrib) {
        NXRuntimeTestCase.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        log.info((Object)("Undeploying contribution from " + url.toString()));
        try {
            this.runtime.getContext().undeploy(url);
        }
        catch (Exception e) {
            log.error((Object)e);
            NXRuntimeTestCase.fail((String)("Failed to undeploy contrib " + url.toString()));
        }
    }

    protected static boolean isVersionSuffix(String s) {
        if (s.length() == 0) {
            return true;
        }
        return s.matches("-(\\d+\\.?)+(-SNAPSHOT)?(\\.\\w+)?");
    }

    protected URL lookupBundleUrl(String bundle) {
        for (URL url : this.urls) {
            String[] pathElts = url.getPath().split("/");
            for (int i = 0; i < pathElts.length; ++i) {
                if (!pathElts[i].startsWith(bundle) || !NXRuntimeTestCase.isVersionSuffix(pathElts[i].substring(bundle.length()))) continue;
                boolean isTestVersion = false;
                for (int j = i + 1; j < pathElts.length; ++j) {
                    if (!pathElts[j].startsWith("test")) continue;
                    isTestVersion = true;
                    break;
                }
                if (isTestVersion) continue;
                log.info((Object)("Resolved " + bundle + " as " + url.toString()));
                return url;
            }
        }
        throw new RuntimeException("Could not resolve bundle " + bundle);
    }

    public void deployBundle(String bundle) throws Exception {
        BundleFile bundleFile = this.lookupBundle(bundle);
        this.bundleLoader.loadBundle(bundleFile);
        this.bundleLoader.installBundle(bundleFile);
    }

    protected String readSymbolicName(BundleFile bf) {
        Manifest manifest = bf.getManifest();
        if (manifest == null) {
            return null;
        }
        Attributes attrs = manifest.getMainAttributes();
        String name = attrs.getValue("Bundle-SymbolicName");
        if (name == null) {
            return null;
        }
        String[] sp = name.split(";", 2);
        return sp[0];
    }

    protected BundleFile lookupBundle(String bundleName) throws Exception {
        Object bundleFile = this.bundles.get(bundleName);
        if (bundleFile != null) {
            return bundleFile;
        }
        for (URL url : this.urls) {
            URI uri = url.toURI();
            if (this.readUris.contains(uri)) continue;
            File file = new File(uri);
            this.readUris.add(uri);
            try {
                bundleFile = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            }
            catch (IOException e) {
                continue;
            }
            String symbolicName = this.readSymbolicName((BundleFile)bundleFile);
            if (symbolicName != null) {
                log.info((Object)String.format("Bundle '%s' has URL %s", symbolicName, url));
                this.bundles.put(symbolicName, (BundleFile)bundleFile);
            }
            if (!bundleName.equals(symbolicName)) continue;
            return bundleFile;
        }
        log.warn((Object)String.format("No bundle with symbolic name '%s'; Falling back to deprecated url lookup scheme", bundleName));
        return this.oldLookupBundle(bundleName);
    }

    @Deprecated
    protected BundleFile oldLookupBundle(String bundle) throws Exception {
        URL url = this.lookupBundleUrl(bundle);
        File file = new File(url.toURI());
        Object bundleFile = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
        log.warn((Object)String.format("URL-based bundle lookup is deprecated. Please use the symbolic name from MANIFEST (%s) instead", this.readSymbolicName((BundleFile)bundleFile)));
        return bundleFile;
    }
}

