/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.LocalDeploy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentSet {
    protected LinkedHashSet<String> deployments = new LinkedHashSet();
    protected LinkedHashSet<String> localDeployments = new LinkedHashSet();

    public void load(AnnotationScanner scanner, Class<?> clazz) {
        scanner.scan(clazz);
        List<? extends Annotation> annos = scanner.getAnnotations(clazz);
        if (annos == null) {
            return;
        }
        for (Annotation annotation : annos) {
            if (annotation.annotationType() == Deploy.class) {
                for (String key : ((Deploy)annotation).value()) {
                    this.deployments.add(key);
                }
                continue;
            }
            if (annotation.annotationType() != LocalDeploy.class) continue;
            for (String key : ((LocalDeploy)annotation).value()) {
                this.localDeployments.add(key);
            }
        }
    }

    public void addDeployment(String key) {
        this.deployments.add(key);
    }

    public void addLocalDeployment(String key) {
        this.localDeployments.add(key);
    }

    public void addDeployment(Collection<String> key) {
        this.deployments.addAll(key);
    }

    public void addLocalDeployment(Collection<String> key) {
        this.localDeployments.addAll(key);
    }

    public Set<String> getDeployments() {
        return this.deployments;
    }

    public Set<String> getLocalDeployments() {
        return this.localDeployments;
    }
}

