/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class JndiHelper {
    public static Context createSubcontext(Context ctx, String name) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        return JndiHelper.createSubcontext(ctx, n);
    }

    public static Context createSubcontext(Context ctx, Name name) throws NamingException {
        Context subctx = ctx;
        for (int pos = 0; pos < name.size(); ++pos) {
            String ctxName = name.get(pos);
            try {
                subctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                subctx = ctx.createSubcontext(ctxName);
            }
            ctx = subctx;
        }
        return subctx;
    }

    public static void bind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        JndiHelper.bind(ctx, n, value);
    }

    public static void bind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = JndiHelper.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.bind(atom, value);
    }

    public static void rebind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        JndiHelper.rebind(ctx, n, value);
    }

    public static void rebind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = JndiHelper.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.rebind(atom, value);
    }

    public static void unbind(Context ctx, String name) throws NamingException {
        JndiHelper.unbind(ctx, ctx.getNameParser("").parse(name));
    }

    public static void unbind(Context ctx, Name name) throws NamingException {
        ctx.unbind(name);
        int sz = name.size();
        while (--sz > 0) {
            Name pname = name.getPrefix(sz);
            try {
                ctx.destroySubcontext(pname);
            }
            catch (NamingException e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

