/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationScanner {
    protected final Map<Class<?>, List<Annotation>> classes = new Hashtable();

    public synchronized void scan(Class<?> clazz) {
        if (this.classes.containsKey(clazz)) {
            return;
        }
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        HashSet visitedClasses = new HashSet();
        this.collectAnnotations(clazz, result, visitedClasses);
    }

    public List<? extends Annotation> getAnnotations(Class<?> clazz) {
        return this.classes.get(clazz);
    }

    public <T extends Annotation> T getFirstAnnotation(Class<?> clazz, Class<T> annotationType) {
        List<T> result = this.getAnnotations(clazz, annotationType);
        if (result != null && !result.isEmpty()) {
            return (T)((Annotation)result.get(0));
        }
        return null;
    }

    public <T extends Annotation> List<T> getAnnotations(Class<?> clazz, Class<T> annotationType) {
        List<Annotation> list = this.classes.get(clazz);
        if (list != null) {
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            for (Annotation anno : list) {
                if (anno.annotationType() != annotationType) continue;
                result.add(anno);
            }
            return result;
        }
        return null;
    }

    protected void collectAnnotations(Class<?> clazz, List<Annotation> result, Set<Class<?>> visitedClasses) {
        if (visitedClasses.contains(clazz)) {
            return;
        }
        visitedClasses.add(clazz);
        ArrayList<Annotation> partialResult = new ArrayList<Annotation>();
        List<Annotation> annos = this.classes.get(clazz);
        if (annos != null) {
            result.addAll(annos);
            return;
        }
        for (Annotation anno : clazz.getAnnotations()) {
            partialResult.add(anno);
        }
        for (Class<?> itf : clazz.getInterfaces()) {
            this.collectAnnotations(itf, partialResult, visitedClasses);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.collectAnnotations(superClass, partialResult, visitedClasses);
        }
        if (!partialResult.isEmpty()) {
            result.addAll(partialResult);
        }
        this.classes.put(clazz, partialResult);
    }
}

