/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.MockObjectTestCase;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.application.StandaloneBundleLoader;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.nuxeo.runtime.test.RootRuntimeBundle;
import org.nuxeo.runtime.test.TestRuntime;
import org.nuxeo.runtime.test.WorkingDirectoryConfigurator;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;

public class NXRuntimeTestCase
extends MockObjectTestCase
implements RuntimeHarness {
    private static final Log log;
    protected RuntimeService runtime;
    protected URL[] urls;
    protected File workingDir;
    private static int counter;
    protected StandaloneBundleLoader bundleLoader;
    private Set<URI> readUris;
    protected Map<String, BundleFile> bundles;
    protected boolean restart = false;
    protected OSGiAdapter osgi;
    protected Bundle runtimeBundle;
    protected final List<WorkingDirectoryConfigurator> wdConfigs = new ArrayList<WorkingDirectoryConfigurator>();

    public NXRuntimeTestCase() {
    }

    public NXRuntimeTestCase(String name) {
        super(name);
    }

    @Override
    public void addWorkingDirectoryConfigurator(WorkingDirectoryConfigurator config) {
        this.wdConfigs.add(config);
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restart() throws Exception {
        this.restart = true;
        try {
            this.tearDown();
            this.setUp();
        }
        finally {
            this.restart = false;
        }
    }

    @Override
    public void start() throws Exception {
        this.setUp();
    }

    public void setUp() throws Exception {
        System.setProperty("org.nuxeo.runtime.testing", "true");
        super.setUp();
        this.wipeRuntime();
        this.initUrls();
        if (this.urls == null) {
            this.initTestRuntime();
        } else {
            this.initOsgiRuntime();
        }
    }

    @Override
    public void fireFrameworkStarted() throws Exception {
        this.osgi.fireFrameworkEvent(new FrameworkEvent(1, this.runtimeBundle, null));
    }

    public void tearDown() throws Exception {
        this.wipeRuntime();
        if (this.workingDir != null && !this.restart) {
            FileUtils.deleteTree((File)this.workingDir);
            this.workingDir = null;
        }
        this.readUris = null;
        this.bundles = null;
        ServiceManager.getInstance().reset();
        super.tearDown();
    }

    @Override
    public void stop() throws Exception {
        this.tearDown();
    }

    @Override
    public boolean isStarted() {
        return this.runtime != null;
    }

    private static synchronized String generateId() {
        long stamp = System.currentTimeMillis();
        return Long.toHexString(stamp) + '-' + System.identityHashCode(System.class) + '.' + ++counter;
    }

    protected void initOsgiRuntime() throws Exception {
        try {
            if (!this.restart) {
                Environment.setDefault(null);
                this.workingDir = File.createTempFile("NXOSGITestFramework", NXRuntimeTestCase.generateId());
                this.workingDir.delete();
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not init working directory", (Throwable)e);
            throw e;
        }
        this.osgi = new OSGiAdapter(this.workingDir);
        this.bundleLoader = new StandaloneBundleLoader(this.osgi, NXRuntimeTestCase.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(this.bundleLoader.getSharedClassLoader().getLoader());
        for (WorkingDirectoryConfigurator cfg : this.wdConfigs) {
            cfg.configure(this, this.workingDir);
        }
        this.bundleLoader.setScanForNestedJARs(false);
        this.bundleLoader.setExtractNestedJARs(false);
        BundleFile bundleFile = this.lookupBundle("org.nuxeo.runtime");
        this.runtimeBundle = new RootRuntimeBundle(this.osgi, bundleFile, this.bundleLoader.getClass().getClassLoader(), true);
        this.runtimeBundle.start();
        this.runtime = Framework.getRuntime();
        NXRuntimeTestCase.assertNotNull((Object)this.runtime);
        this.deployContrib(bundleFile, "OSGI-INF/DeploymentService.xml");
        this.deployContrib(bundleFile, "OSGI-INF/LoginComponent.xml");
        this.deployContrib(bundleFile, "OSGI-INF/ServiceManagement.xml");
        this.deployContrib(bundleFile, "OSGI-INF/EventService.xml");
        this.deployContrib(bundleFile, "OSGI-INF/ResourceService.xml");
        this.deployContrib(bundleFile, "OSGI-INF/DefaultJBossBindings.xml");
        this.deployContrib(bundleFile, "OSGI-INF/ContributionPersistence.xml");
    }

    protected void initTestRuntime() throws Exception {
        this.runtime = new TestRuntime();
        Framework.initialize((RuntimeService)this.runtime);
        this.deployContrib("org.nuxeo.runtime.test", "EventService.xml");
        this.deployContrib("org.nuxeo.runtime.test", "DeploymentService.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initUrls() throws Exception {
        block14: {
            ClassLoader classLoader = NXRuntimeTestCase.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                this.urls = ((URLClassLoader)classLoader).getURLs();
            } else if (classLoader.getClass().getName().equals("org.apache.tools.ant.AntClassLoader")) {
                Method method = classLoader.getClass().getMethod("getClasspath", new Class[0]);
                String cp = (String)method.invoke((Object)classLoader, new Object[0]);
                String[] paths = cp.split(File.pathSeparator);
                this.urls = new URL[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    this.urls[i] = new URL("file:" + paths[i]);
                }
            } else {
                log.warn((Object)("Unknow classloader type: " + classLoader.getClass().getName() + "\nWon't be able to load OSGI bundles"));
                return;
            }
            if (this.urls.length == 1) {
                try {
                    URI uri = this.urls[0].toURI();
                    if (!uri.getScheme().equals("file") || !uri.getPath().contains("surefirebooter")) break block14;
                    JarFile jar = new JarFile(new File(uri));
                    try {
                        String cp = jar.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if (cp != null) {
                            String[] cpe = cp.split(" ");
                            URL[] newUrls = new URL[cpe.length];
                            for (int i = 0; i < cpe.length; ++i) {
                                String newUrl = cpe[i].startsWith("file:") ? cpe[i] : "file:" + cpe[i];
                                newUrls[i] = new URL(newUrl);
                            }
                            this.urls = newUrls;
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("URLs on the classpath: ");
        for (URL url : this.urls) {
            sb.append(url.toString());
            sb.append('\n');
        }
        log.debug((Object)sb.toString());
        this.readUris = new HashSet<URI>();
        this.bundles = new HashMap<String, BundleFile>();
    }

    protected void wipeRuntime() throws Exception {
        this.runtime = null;
        if (Framework.getRuntime() != null) {
            Framework.shutdown();
        }
    }

    public static URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    @Override
    @Deprecated
    public void deploy(String contrib) {
        this.deployContrib(contrib);
    }

    protected void deployContrib(URL url) {
        NXRuntimeTestCase.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        log.info((Object)("Deploying contribution from " + url.toString()));
        try {
            this.runtime.getContext().deploy(url);
        }
        catch (Exception e) {
            log.error((Object)e);
            NXRuntimeTestCase.fail((String)("Failed to deploy contrib " + url.toString()));
        }
    }

    @Override
    @Deprecated
    public void deployContrib(String contrib) {
        URL url = NXRuntimeTestCase.getResource(contrib);
        NXRuntimeTestCase.assertNotNull((String)("Test contribution not found: " + contrib), (Object)url);
        this.deployContrib(url);
    }

    protected void deployContrib(BundleFile bundleFile, String contrib) {
        URL url = bundleFile.getEntry(contrib);
        if (url == null) {
            NXRuntimeTestCase.fail((String)String.format("Could not find entry %s in bundle '%s", contrib, bundleFile.getURL()));
        }
        this.deployContrib(url);
    }

    @Override
    public void deployContrib(String bundle, String contrib) throws Exception {
        this.deployContrib(this.lookupBundle(bundle), contrib);
    }

    @Override
    public RuntimeContext deployTestContrib(String bundle, String contrib) throws Exception {
        BundleImpl b = this.bundleLoader.getOSGi().getRegistry().getBundle(bundle);
        if (b != null) {
            OSGiRuntimeContext ctx = new OSGiRuntimeContext(this.runtime, (Bundle)b);
            ctx.deploy(contrib);
            return ctx;
        }
        throw new IllegalArgumentException("Bundle not deployed " + bundle);
    }

    @Override
    public RuntimeContext deployTestContrib(String bundle, URL contrib) throws Exception {
        BundleImpl b = this.bundleLoader.getOSGi().getRegistry().getBundle(bundle);
        if (b != null) {
            OSGiRuntimeContext ctx = new OSGiRuntimeContext(this.runtime, (Bundle)b);
            ctx.deploy(contrib);
            return ctx;
        }
        throw new IllegalArgumentException("Bundle not deployed " + bundle);
    }

    @Override
    @Deprecated
    public void undeploy(String contrib) {
        this.undeployContrib(contrib);
    }

    @Override
    @Deprecated
    public void undeployContrib(String contrib) {
        URL url = NXRuntimeTestCase.getResource(contrib);
        NXRuntimeTestCase.assertNotNull((String)("Test contribution not found: " + contrib), (Object)url);
        this.deployContrib(url);
    }

    @Override
    public void undeployContrib(String bundle, String contrib) throws Exception {
        BundleFile b = this.lookupBundle(bundle);
        URL url = b.getEntry(contrib);
        if (url == null) {
            NXRuntimeTestCase.fail((String)String.format("Could not find entry %s in bundle '%s'", contrib, b.getURL()));
        }
        this.runtime.getContext().undeploy(url);
    }

    @Deprecated
    protected void undeployContrib(URL url, String contrib) {
        NXRuntimeTestCase.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        log.info((Object)("Undeploying contribution from " + url.toString()));
        try {
            this.runtime.getContext().undeploy(url);
        }
        catch (Exception e) {
            log.error((Object)e);
            NXRuntimeTestCase.fail((String)("Failed to undeploy contrib " + url.toString()));
        }
    }

    protected static boolean isVersionSuffix(String s) {
        if (s.length() == 0) {
            return true;
        }
        return s.matches("-(\\d+\\.?)+(-SNAPSHOT)?(\\.\\w+)?");
    }

    protected URL lookupBundleUrl(String bundle) {
        for (URL url : this.urls) {
            String[] pathElts = url.getPath().split("/");
            for (int i = 0; i < pathElts.length; ++i) {
                if (!pathElts[i].startsWith(bundle) || !NXRuntimeTestCase.isVersionSuffix(pathElts[i].substring(bundle.length()))) continue;
                boolean isTestVersion = false;
                for (int j = i + 1; j < pathElts.length; ++j) {
                    if (!pathElts[j].startsWith("test")) continue;
                    isTestVersion = true;
                    break;
                }
                if (isTestVersion) continue;
                log.info((Object)("Resolved " + bundle + " as " + url.toString()));
                return url;
            }
        }
        throw new RuntimeException("Could not resolve bundle " + bundle);
    }

    @Override
    public void deployBundle(String bundle) throws Exception {
        if (this.bundleLoader.getOSGi().getRegistry().getBundle(bundle) == null) {
            BundleFile bundleFile = this.lookupBundle(bundle);
            this.bundleLoader.loadBundle(bundleFile);
            this.bundleLoader.installBundle(bundleFile);
        }
    }

    protected String readSymbolicName(BundleFile bf) {
        Manifest manifest = bf.getManifest();
        if (manifest == null) {
            return null;
        }
        Attributes attrs = manifest.getMainAttributes();
        String name = attrs.getValue("Bundle-SymbolicName");
        if (name == null) {
            return null;
        }
        String[] sp = name.split(";", 2);
        return sp[0];
    }

    public BundleFile lookupBundle(String bundleName) throws Exception {
        Object bundleFile = this.bundles.get(bundleName);
        if (bundleFile != null) {
            return bundleFile;
        }
        for (URL url : this.urls) {
            URI uri = url.toURI();
            if (this.readUris.contains(uri)) continue;
            File file = new File(uri);
            this.readUris.add(uri);
            try {
                bundleFile = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            }
            catch (IOException e) {
                continue;
            }
            String symbolicName = this.readSymbolicName((BundleFile)bundleFile);
            if (symbolicName != null) {
                log.info((Object)String.format("Bundle '%s' has URL %s", symbolicName, url));
                this.bundles.put(symbolicName, (BundleFile)bundleFile);
            }
            if (!bundleName.equals(symbolicName)) continue;
            return bundleFile;
        }
        log.warn((Object)String.format("No bundle with symbolic name '%s'; Falling back to deprecated url lookup scheme", bundleName));
        return this.oldLookupBundle(bundleName);
    }

    @Deprecated
    protected BundleFile oldLookupBundle(String bundle) throws Exception {
        URL url = this.lookupBundleUrl(bundle);
        File file = new File(url.toURI());
        Object bundleFile = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
        log.warn((Object)String.format("URL-based bundle lookup is deprecated. Please use the symbolic name from MANIFEST (%s) instead", this.readSymbolicName((BundleFile)bundleFile)));
        return bundleFile;
    }

    @Override
    public void deployFolder(File folder, ClassLoader loader) throws Exception {
        DirectoryBundleFile bf = new DirectoryBundleFile(folder);
        BundleImpl bundle = new BundleImpl(this.osgi, (BundleFile)bf, loader);
        this.osgi.install(bundle);
    }

    @Override
    public Properties getProperties() {
        return this.runtime.getProperties();
    }

    @Override
    public RuntimeContext getContext() {
        return this.runtime.getContext();
    }

    @Override
    public OSGiAdapter getOSGiAdapter() {
        return this.osgi;
    }

    static {
        System.setProperty("org.nuxeo.runtime.redirectJUL", "false");
        log = LogFactory.getLog(NXRuntimeTestCase.class);
        counter = 0;
    }
}

