/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.test.WorkingDirectoryConfigurator;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.runtime.jetty"})
@Features(value={RuntimeFeature.class})
public class JettyFeature
extends SimpleFeature
implements WorkingDirectoryConfigurator {
    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        Jetty jetty = FeaturesRunner.getScanner().getFirstAnnotation(runner.getTargetTestClass(), Jetty.class);
        if (jetty == null) {
            jetty = Defaults.of(Jetty.class);
        }
        this.configureJetty(jetty);
        runner.getFeature(RuntimeFeature.class).getHarness().addWorkingDirectoryConfigurator(this);
    }

    protected void configureJetty(Jetty jetty) {
        String config;
        String host;
        int p = jetty.port();
        try {
            String s = System.getenv("JETTY_PORT");
            if (s != null) {
                p = Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (p > 0) {
            System.setProperty("jetty.port", Integer.toString(p));
        }
        if ((host = System.getenv("JETTY_HOST")) == null) {
            host = jetty.host();
        }
        if (host.length() > 0) {
            System.setProperty("jetty.host", host);
        }
        if ((config = System.getenv("JETTY_CONFIG")) == null) {
            config = jetty.config();
        }
        if (config.length() > 0) {
            System.setProperty("org.nuxeo.jetty.config", config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(RuntimeHarness harness, File workingDir) throws IOException {
        File dest = new File(workingDir, "config");
        dest.mkdirs();
        InputStream in = JettyFeature.getResource("jetty/default-web.xml").openStream();
        dest = new File(workingDir + "/config", "default-web.xml");
        try {
            FileUtils.copyToFile((InputStream)in, (File)dest);
        }
        finally {
            in.close();
        }
        in = JettyFeature.getResource("jetty/jetty.xml").openStream();
        dest = new File(workingDir + "/config", "jetty.xml");
        try {
            FileUtils.copyToFile((InputStream)in, (File)dest);
        }
        finally {
            in.close();
        }
    }

    private static URL getResource(String resource) {
        return Jetty.class.getClassLoader().getResource(resource);
    }
}

