/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.configuration.MockProvider;
import org.mockito.configuration.RuntimeService;
import org.mockito.internal.configuration.FieldAnnotationProcessor;

public class NuxeoServiceMockAnnotationProcessor
implements FieldAnnotationProcessor<Mock> {
    public Object process(Mock annotation, Field field) {
        Object mock = Mockito.mock(field.getType(), (String)field.getName());
        for (Annotation ann : field.getAnnotations()) {
            if (!ann.annotationType().equals(RuntimeService.class)) continue;
            this.bindMockAsNuxeoService(field, mock);
        }
        return mock;
    }

    private void bindMockAsNuxeoService(Field field, Object mock) {
        MockProvider.INSTANCE.bind(field.getType(), mock);
    }
}

