/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.test.protocols.inline.InlineURLFactory;

public class InlineRef
implements StreamRef {
    protected final String id;
    protected final String content;

    public InlineRef(String id, String content) {
        this.id = id;
        this.content = content;
    }

    public String getId() {
        return this.id;
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.content.getBytes());
    }

    public URL asURL() {
        try {
            return InlineURLFactory.newURL(this.content);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot encode inline:... URL", e);
        }
    }
}

