/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.mockito.MockitoAnnotations;
import org.mockito.configuration.MockProvider;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.test.protocols.inline.InlineURLFactory;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class FeaturesRunner
extends BlockJUnit4ClassRunner {
    protected static final AnnotationScanner scanner = new AnnotationScanner();
    protected Injector injector;
    protected List<RunnerFeature> features;
    protected final RunListener listener = new RunListener(){

        public void testStarted(Description description) throws Exception {
            for (RunnerFeature feature : FeaturesRunner.this.features) {
                feature.beforeSetup(FeaturesRunner.this);
            }
        }

        public void testFinished(Description description) throws Exception {
            for (RunnerFeature feature : FeaturesRunner.reversed(FeaturesRunner.this.features)) {
                feature.afterTeardown(FeaturesRunner.this);
            }
        }
    };

    public static AnnotationScanner getScanner() {
        return scanner;
    }

    public static <T> List<T> reversed(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    public FeaturesRunner(Class<?> classToRun) throws InitializationError {
        super(classToRun);
        try {
            InlineURLFactory.install();
            this.loadFeatures(this.getTestClass().getJavaClass());
            this.initialize();
        }
        catch (Throwable t) {
            throw new InitializationError(Collections.singletonList(t));
        }
    }

    public Class<?> getTargetTestClass() {
        return super.getTestClass().getJavaClass();
    }

    protected void loadFeature(HashSet<Class<?>> cycles, LinkedHashSet<Class<? extends RunnerFeature>> features, Class<? extends RunnerFeature> clazz) throws Exception {
        if (features.contains(clazz)) {
            return;
        }
        if (cycles.contains(clazz)) {
            throw new IllegalStateException("Cycle detected in features dependencies of " + clazz);
        }
        cycles.add(clazz);
        scanner.scan(clazz);
        List<Features> annos = scanner.getAnnotations(clazz, Features.class);
        if (annos != null) {
            for (Features anno : annos) {
                for (Class<? extends RunnerFeature> cl : anno.value()) {
                    if (features.contains(cl)) continue;
                    this.loadFeature(cycles, features, cl);
                }
            }
        }
        features.add(clazz);
    }

    protected void loadFeatures(Class<?> classToRun) throws Exception {
        scanner.scan(classToRun);
        LinkedHashSet<Class<? extends RunnerFeature>> features = new LinkedHashSet<Class<? extends RunnerFeature>>();
        List<Features> annos = scanner.getAnnotations(classToRun, Features.class);
        if (annos != null) {
            for (Features features2 : annos) {
                for (Class<? extends RunnerFeature> cl : features2.value()) {
                    if (features.contains(cl)) continue;
                    this.loadFeature(new HashSet(), features, cl);
                }
            }
        }
        this.features = new ArrayList<RunnerFeature>();
        for (Class clazz : features) {
            RunnerFeature rf = (RunnerFeature)clazz.newInstance();
            this.features.add(rf);
        }
    }

    public <T extends RunnerFeature> T getFeature(Class<T> type) {
        for (RunnerFeature rf : this.features) {
            if (rf.getClass() != type) continue;
            return (T)((RunnerFeature)type.cast(rf));
        }
        return null;
    }

    public List<RunnerFeature> getFeatures() {
        return this.features;
    }

    public <T extends Annotation> T getConfig(Class<T> type) {
        Annotation config = this.getDescription().getAnnotation(type);
        if (config != null) {
            return (T)config;
        }
        for (RunnerFeature feature : this.features) {
            config = feature.getClass().getAnnotation(type);
            if (config == null) continue;
            return (T)config;
        }
        return null;
    }

    public <T extends Annotation> T getConfig(FrameworkMethod method, Class<T> type) {
        Annotation config = method.getAnnotation(type);
        if (config != null) {
            return (T)config;
        }
        return this.getConfig(type);
    }

    protected void initialize() throws Exception {
        for (RunnerFeature feature : this.features) {
            feature.initialize(this);
        }
    }

    protected void beforeRun() throws Exception {
        for (RunnerFeature feature : this.features) {
            feature.beforeRun(this);
        }
    }

    protected void beforeMethodRun(FrameworkMethod method, Object test) throws Exception {
        for (RunnerFeature feature : this.features) {
            feature.beforeMethodRun(this, method, test);
        }
        this.injector.injectMembers(test);
    }

    protected void afterMethodRun(FrameworkMethod method, Object test) throws Exception {
        for (RunnerFeature feature : FeaturesRunner.reversed(this.features)) {
            feature.afterMethodRun(this, method, test);
        }
    }

    protected void afterRun() throws Exception {
        for (RunnerFeature feature : FeaturesRunner.reversed(this.features)) {
            feature.afterRun(this);
        }
    }

    protected void testCreated(Object test) throws Exception {
        for (RunnerFeature feature : this.features) {
            feature.testCreated(test);
        }
    }

    protected void start() throws Exception {
        for (RunnerFeature feature : this.features) {
            feature.start(this);
        }
    }

    protected void stop() throws Exception {
        for (RunnerFeature feature : FeaturesRunner.reversed(this.features)) {
            feature.stop(this);
        }
    }

    protected void configureBindings(Binder binder) {
        binder.bind(FeaturesRunner.class).toInstance((Object)this);
        for (RunnerFeature feature : this.features) {
            feature.configure(this, binder);
        }
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void resetInjector() {
        this.injector = this.createInjector();
    }

    protected Injector createInjector() {
        Module module = new Module(){

            public void configure(Binder arg0) {
                FeaturesRunner.this.configureBindings(arg0);
            }
        };
        return Guice.createInjector((Module[])new Module[]{module});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            notifier.addFirstListener(this.listener);
            try {
                this.start();
                this.resetInjector();
                try {
                    this.beforeRun();
                    super.run(notifier);
                }
                finally {
                    this.afterRun();
                }
            }
            finally {
                this.stop();
            }
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), e));
        }
        finally {
            notifier.removeListener(this.listener);
        }
    }

    public Object createTest() throws Exception {
        Object test = this.injector.getInstance(this.getTestClass().getJavaClass());
        DefaultServiceProvider.setProvider((ServiceProvider)MockProvider.INSTANCE);
        MockitoAnnotations.initMocks((Object)test);
        try {
            this.testCreated(test);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to prepare test instance: " + test, e);
        }
        return test;
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InvokeMethod(method, test);
    }

    protected class InvokeMethod
    extends Statement {
        protected final FrameworkMethod testMethod;
        protected final Object target;

        protected InvokeMethod(FrameworkMethod testMethod, Object target) {
            this.testMethod = testMethod;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            FeaturesRunner.this.beforeMethodRun(this.testMethod, this.target);
            try {
                this.testMethod.invokeExplosively(this.target, new Object[0]);
            }
            finally {
                FeaturesRunner.this.afterMethodRun(this.testMethod, this.target);
            }
        }
    }
}

