/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.mockito.MockProvider;
import org.nuxeo.runtime.mockito.RuntimeService;

public class NuxeoServiceMockAnnotationProcessor
implements FieldAnnotationProcessor<Mock> {
    public Object process(Mock annotation, Field field) {
        Object mock = Mockito.mock(field.getType(), (String)field.getName());
        for (Annotation ann : field.getAnnotations()) {
            if (!ann.annotationType().equals(RuntimeService.class)) continue;
            this.bindMockAsNuxeoService(field, mock);
        }
        return mock;
    }

    protected void bindMockAsNuxeoService(Field field, Object mock) {
        MockProvider provider = (MockProvider)DefaultServiceProvider.getProvider();
        provider.bind(field.getType(), mock);
    }
}

