/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat;

import java.io.File;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.ContainerBase;
import org.nuxeo.osgi.application.FrameworkBootstrap;

public class NuxeoLauncher2
implements LifecycleListener {
    protected String home = "nxserver";
    protected FrameworkBootstrap bootstrap;

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle lf = event.getLifecycle();
        if (lf instanceof ContainerBase) {
            ContainerBase container = (ContainerBase)lf;
            this.handleEvent(container, event);
        }
    }

    protected void handleEvent(ContainerBase container, LifecycleEvent event) {
        try {
            ClassLoader cl = container.getParentClassLoader();
            String type = event.getType();
            if (type == "before_start") {
                File homeDir = this.resolveHomeDirectory();
                this.bootstrap = new FrameworkBootstrap(cl, homeDir);
                this.bootstrap.env().put("org.nuxeo.app.data", System.getProperty("nuxeo.data.dir"));
                this.bootstrap.env().put("org.nuxeo.app.log", System.getProperty("nuxeo.log.dir"));
                this.bootstrap.env().put("org.nuxeo.app.tmp", System.getProperty("nuxeo.tmp.dir"));
                this.bootstrap.setHostName("Tomcat");
                this.bootstrap.setHostVersion("6.0.20");
                this.bootstrap.initialize();
                this.bootstrap.start();
            } else if (type == "stop") {
                this.bootstrap.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to handle event", e);
        }
    }

    protected File resolveHomeDirectory() {
        String path = null;
        path = this.home.startsWith("/") ? this.home : this.getTomcatHome() + "/" + this.home;
        return new File(path);
    }

    public String getTomcatHome() {
        String tomcatHome = System.getProperty("catalina.base");
        if (tomcatHome == null) {
            tomcatHome = System.getProperty("catalina.home");
        }
        return tomcatHome;
    }
}

