/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.nuxeo.osgi.application.FrameworkBootstrap;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.dev.NuxeoDevWebappClassLoader;

public class DevFrameworkBootstrap
extends FrameworkBootstrap {
    protected File devBundlesFile;
    protected DevBundle[] devBundles;
    protected Timer bundlesCheck;
    protected long lastModified = 0L;

    public DevFrameworkBootstrap(ClassLoader cl, File home) throws IOException {
        super(cl, home);
    }

    public DevFrameworkBootstrap(MutableClassLoader cl, File home) throws IOException {
        super(cl, home);
        this.devBundlesFile = new File(home, "dev.bundles");
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.bundlesCheck = new Timer("Dev Bundles Loader");
        this.bundlesCheck.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    DevFrameworkBootstrap.this.checkDevBundles();
                }
                catch (Throwable t) {
                    log.error((Object)"Error running dev mode timer", t);
                }
            }
        }, 0L, 2000L);
    }

    @Override
    public void stop() throws Exception {
        if (this.bundlesCheck != null) {
            this.bundlesCheck.cancel();
            this.bundlesCheck = null;
        }
        super.stop();
    }

    protected void checkDevBundles() {
        long tm = this.devBundlesFile.lastModified();
        if (this.lastModified >= tm) {
            return;
        }
        this.lastModified = tm;
        try {
            this.reloadDevBundles(this.getDevBundles());
        }
        catch (Exception e) {
            log.error((Object)"Faied to deploy dev bundles", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DevBundle[] getDevBundles() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.devBundlesFile)));
        try {
            ArrayList<DevBundle> urls = new ArrayList<DevBundle>();
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    if (line.startsWith("!")) {
                        urls.add(new DevBundle(new File(line.substring(1)), true));
                    } else {
                        urls.add(new DevBundle(new File(line)));
                    }
                }
                line = reader.readLine();
            }
            DevBundle[] devBundleArray = urls.toArray(new DevBundle[urls.size()]);
            return devBundleArray;
        }
        finally {
            reader.close();
        }
    }

    protected synchronized void reloadDevBundles(DevBundle[] bundles) throws Exception {
        if (this.devBundles != null) {
            for (DevBundle bundle : this.devBundles) {
                if (bundle.isLibrary() || bundle.name == null) continue;
                this.uninstallBundle(bundle.name);
            }
        }
        this.devBundles = bundles;
        NuxeoDevWebappClassLoader devLoader = (NuxeoDevWebappClassLoader)this.loader;
        devLoader.clear();
        URL[] urls = new URL[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            urls[i] = bundles[i].url();
        }
        devLoader.createLocalClassLoader(urls);
        for (URL url : urls) {
            for (DevBundle bundle : this.devBundles) {
                if (bundle.isLibrary()) continue;
                bundle.name = this.installBundle(bundle.file);
            }
        }
    }

    static class DevBundle {
        String name;
        boolean isLibrary;
        File file;

        public DevBundle(File file) {
            this(file, false);
        }

        public DevBundle(File file, boolean isLibrary) {
            this.file = file;
            this.isLibrary = isLibrary;
        }

        public URL url() throws IOException {
            return this.file.toURI().toURL();
        }

        public boolean isLibrary() {
            return this.isLibrary;
        }
    }
}

