/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.loader.WebappClassLoader;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.dev.LocalClassLoader;
import org.nuxeo.runtime.tomcat.dev.LocalURLClassLoader;

public class NuxeoDevWebappClassLoader
extends WebappClassLoader
implements MutableClassLoader {
    protected List<LocalClassLoader> children = new ArrayList<LocalClassLoader>();
    protected volatile LocalClassLoader[] _children;

    public LocalClassLoader createLocalClassLoader(URL ... urls) {
        LocalURLClassLoader cl = new LocalURLClassLoader(urls, (ClassLoader)((Object)this));
        this.addChildren(cl);
        return cl;
    }

    public NuxeoDevWebappClassLoader() {
    }

    public NuxeoDevWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    public synchronized void addChildren(LocalClassLoader loader) {
        this.children.add(loader);
        this._children = null;
    }

    public synchronized void removeChildren(ClassLoader loader) {
        this.children.remove(loader);
        this._children = null;
    }

    public synchronized void clear() {
        this.children.clear();
        this._children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalClassLoader[] getChildren() {
        LocalClassLoader[] cls = this._children;
        if (cls == null) {
            NuxeoDevWebappClassLoader nuxeoDevWebappClassLoader = this;
            synchronized (nuxeoDevWebappClassLoader) {
                this._children = this.children.toArray(new LocalClassLoader[this.children.size()]);
                cls = this._children;
            }
        }
        return cls;
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            for (LocalClassLoader cl : this.getChildren()) {
                try {
                    return cl.loadLocalClass(name, resolve);
                }
                catch (ClassNotFoundException ee) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void setParentClassLoader(ClassLoader pcl) {
        super.setParentClassLoader(pcl);
    }

    public ClassLoader getParentClassLoader() {
        return this.parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }
}

