/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.File;
import java.lang.reflect.Method;
import org.nuxeo.runtime.tomcat.dev.DevBundle;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;

public class ReloadServiceInvoker {
    protected Object reloadService;
    protected Method deployBundle;
    protected Method undeployBundle;
    protected Method flush;
    protected Method reload;

    public ReloadServiceInvoker(ClassLoader cl) throws Exception {
        Class<?> frameworkClass = cl.loadClass("org.nuxeo.runtime.api.Framework");
        Class<?> reloadServiceClass = cl.loadClass("org.nuxeo.runtime.reload.ReloadService");
        Method getLocalService = frameworkClass.getDeclaredMethod("getLocalService", Class.class);
        this.reloadService = getLocalService.invoke(null, reloadServiceClass);
        this.deployBundle = reloadServiceClass.getDeclaredMethod("deployBundle", File.class);
        this.undeployBundle = reloadServiceClass.getDeclaredMethod("undeployBundle", String.class);
        this.flush = reloadServiceClass.getDeclaredMethod("flush", new Class[0]);
        this.reload = reloadServiceClass.getDeclaredMethod("reload", new Class[0]);
    }

    protected void hotDeployBundles(DevBundle[] bundles) throws Exception {
        for (DevBundle bundle : bundles) {
            if (bundle.devBundleType != DevBundleType.Bundle) continue;
            bundle.name = (String)this.deployBundle.invoke(this.reloadService, bundle.file());
        }
        this.reload();
    }

    protected void hotUndeployBundles(DevBundle[] bundles) throws Exception {
        for (DevBundle bundle : bundles) {
            if (bundle.devBundleType != DevBundleType.Bundle || bundle.name == null) continue;
            this.undeployBundle.invoke(this.reloadService, bundle.name);
        }
        this.flush();
    }

    protected void flush() throws Exception {
        this.flush.invoke(this.reloadService, new Object[0]);
    }

    protected void reload() throws Exception {
        this.reload.invoke(this.reloadService, new Object[0]);
    }
}

